/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduMetrics;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.TestKuduClient;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.MetricTestUtils;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestScanToken {
    private static final Logger LOG = LoggerFactory.getLogger(TestKuduClient.class);
    private static final String testTableName = "TestScanToken";
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().enableKerberos().addTabletServerFlag("--tserver_enforce_access_control=true");
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanTokens() throws Exception {
        int saveFetchTablets = AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP;
        try {
            AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP = 4;
            Schema schema = ClientTestUtil.createManyStringsSchema();
            CreateTableOptions createOptions = new CreateTableOptions();
            createOptions.addHashPartitions((List)ImmutableList.of((Object)"key"), 8);
            PartialRow splitRow = schema.newPartialRow();
            splitRow.addString("key", "key_50");
            createOptions.addSplitRow(splitRow);
            this.client.createTable(testTableName, schema, createOptions);
            KuduSession session = this.client.newSession();
            session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
            KuduTable table = this.client.openTable(testTableName);
            for (int i = 0; i < 100; ++i) {
                Insert insert = table.newInsert();
                PartialRow row = insert.getRow();
                row.addString("key", String.format("key_%02d", i));
                row.addString("c1", "c1_" + i);
                row.addString("c2", "c2_" + i);
                session.apply((Operation)insert);
            }
            session.flush();
            KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
            tokenBuilder.batchSizeBytes(0);
            tokenBuilder.setProjectedColumnIndexes((List)ImmutableList.of());
            List tokens = tokenBuilder.build();
            Assert.assertEquals((long)16L, (long)tokens.size());
            KuduScanner scanner = ((KuduScanToken)tokens.get(0)).intoScanner(this.client);
            Assert.assertEquals((long)0L, (long)scanner.nextRows().getNumRows());
            for (KuduScanToken token : tokens) {
                LOG.debug(KuduScanToken.stringifySerializedToken((byte[])token.serialize(), (KuduClient)this.client));
            }
        }
        finally {
            AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP = saveFetchTablets;
        }
    }

    @Test
    public void testScanTokensNonCoveringRangePartitions() throws Exception {
        PartialRow row;
        Insert insert;
        char c;
        Schema schema = ClientTestUtil.createManyStringsSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.addHashPartitions((List)ImmutableList.of((Object)"key"), 2);
        PartialRow lower = schema.newPartialRow();
        PartialRow upper = schema.newPartialRow();
        lower.addString("key", "a");
        upper.addString("key", "f");
        createOptions.addRangePartition(lower, upper);
        lower = schema.newPartialRow();
        upper = schema.newPartialRow();
        lower.addString("key", "h");
        upper.addString("key", "z");
        createOptions.addRangePartition(lower, upper);
        PartialRow split = schema.newPartialRow();
        split.addString("key", "k");
        createOptions.addSplitRow(split);
        this.client.createTable(testTableName, schema, createOptions);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        KuduTable table = this.client.openTable(testTableName);
        for (c = 'a'; c < 'f'; c = (char)(c + '\u0001')) {
            insert = table.newInsert();
            row = insert.getRow();
            row.addString("key", "" + c);
            row.addString("c1", "c1_" + c);
            row.addString("c2", "c2_" + c);
            session.apply((Operation)insert);
        }
        for (c = 'h'; c < 'z'; c = (char)(c + '\u0001')) {
            insert = table.newInsert();
            row = insert.getRow();
            row.addString("key", "" + c);
            row.addString("c1", "c1_" + c);
            row.addString("c2", "c2_" + c);
            session.apply((Operation)insert);
        }
        session.flush();
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
        tokenBuilder.setProjectedColumnIndexes((List)ImmutableList.of());
        List tokens = tokenBuilder.build();
        Assert.assertEquals((long)6L, (long)tokens.size());
        Assert.assertEquals((long)23L, (long)ClientTestUtil.countScanTokenRows((List)tokens, (String)this.client.getMasterAddressesAsString(), (long)this.client.getDefaultOperationTimeoutMs()));
        for (KuduScanToken token : tokens) {
            LOG.debug(KuduScanToken.stringifySerializedToken((byte[])token.serialize(), (KuduClient)this.client));
        }
    }

    @Test
    public void testScanTokensConcurrentAlterTable() throws Exception {
        Schema schema = new Schema((List)ImmutableList.of((Object)new ColumnSchema.ColumnSchemaBuilder("key", Type.INT64).nullable(false).key(true).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("a", Type.INT64).nullable(false).key(false).build()));
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        this.client.createTable(testTableName, schema, createOptions);
        KuduTable table = this.client.openTable(testTableName);
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
        List tokens = tokenBuilder.includeTableMetadata(false).build();
        List tokensWithMetadata = tokenBuilder.includeTableMetadata(true).build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((long)1L, (long)tokensWithMetadata.size());
        KuduScanToken token = (KuduScanToken)tokens.get(0);
        KuduScanToken tokenWithMetadata = (KuduScanToken)tokensWithMetadata.get(0);
        this.client.alterTable(testTableName, new AlterTableOptions().dropColumn("a"));
        try {
            token.intoScanner(this.client);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown column"));
        }
        try {
            KuduScanner scanner = tokenWithMetadata.intoScanner(this.client);
            ClientTestUtil.countRowsInScan((KuduScanner)scanner);
            Assert.fail();
        }
        catch (KuduException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Some columns are not present in the current schema: a"));
        }
        this.client.alterTable(testTableName, new AlterTableOptions().addColumn(new ColumnSchema.ColumnSchemaBuilder("a", Type.INT64).nullable(false).defaultValue((Object)0L).build()));
        try {
            token.intoScanner(this.client);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown column"));
        }
    }

    @Test
    public void testScanTokensConcurrentColumnRename() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        String oldColName = schema.getColumnByIndex(1).getName();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        this.client.createTable(testTableName, schema, createOptions);
        KuduTable table = this.client.openTable(testTableName);
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
        tokenBuilder.includeTableMetadata(false);
        List tokens = tokenBuilder.build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        KuduScanToken token = (KuduScanToken)tokens.get(0);
        String newColName = "new-name";
        this.client.alterTable(testTableName, new AlterTableOptions().renameColumn(oldColName, newColName));
        KuduScanner scanner = token.intoScanner(this.client);
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)scanner));
        Schema alteredSchema = scanner.getProjectionSchema();
        try {
            alteredSchema.getColumn(oldColName);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        alteredSchema.getColumn(newColName);
    }

    @Test
    public void testScanTokensWithTableRename() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
        List tokens = tokenBuilder.build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        KuduScanToken token = (KuduScanToken)tokens.get(0);
        this.client.alterTable(testTableName, new AlterTableOptions().renameTable("TestScanToken-renamed"));
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)token.intoScanner(this.client)));
    }

    @Test
    public void testScanTokensInterleavedRangePartitionDrops() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.addHashPartitions((List)ImmutableList.of((Object)"key"), 2);
        int numRows = 30;
        PartialRow lower0 = schema.newPartialRow();
        PartialRow upper0 = schema.newPartialRow();
        lower0.addInt("key", 0);
        upper0.addInt("key", 10);
        createOptions.addRangePartition(lower0, upper0);
        PartialRow lower1 = schema.newPartialRow();
        PartialRow upper1 = schema.newPartialRow();
        lower1.addInt("key", 10);
        upper1.addInt("key", 20);
        createOptions.addRangePartition(lower1, upper1);
        PartialRow lower2 = schema.newPartialRow();
        PartialRow upper2 = schema.newPartialRow();
        lower2.addInt("key", 20);
        upper2.addInt("key", 30);
        createOptions.addRangePartition(lower2, upper2);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        KuduSession session = this.client.newSession();
        for (int i = 0; i < 30; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        List tokens = this.client.newScanTokenBuilder(table).build();
        Assert.assertEquals((long)6L, (long)tokens.size());
        AlterTableOptions dropMiddleOptions = new AlterTableOptions();
        dropMiddleOptions.dropRangePartition(lower1, upper1);
        this.client.alterTable(table.getName(), dropMiddleOptions);
        ArrayList<KuduScanner> scanners = new ArrayList<KuduScanner>();
        for (KuduScanToken token : tokens) {
            scanners.add(token.intoScanner(this.client));
        }
        AlterTableOptions dropEndOptions = new AlterTableOptions();
        dropEndOptions.dropRangePartition(lower2, upper2);
        this.client.alterTable(table.getName(), dropEndOptions);
        int scannedRows = 0;
        for (KuduScanner scanner : scanners) {
            scannedRows += ClientTestUtil.countRowsInScan((KuduScanner)scanner);
        }
        Assert.assertTrue((String)String.format("%d >= %d / 3?", scannedRows, 30), (scannedRows >= 10 ? 1 : 0) != 0);
        Assert.assertTrue((String)String.format("%d <= 2 * %d / 3?", scannedRows, 30), (scannedRows <= 20 ? 1 : 0) != 0);
    }

    @Test
    public void testScanRequestTimeout() throws IOException {
        int NUM_ROWS_DESIRED = 100;
        int SCAN_REQUEST_TIMEOUT_MS = 20;
        KuduTable table = ClientTestUtil.createDefaultTable((KuduClient)this.client, (String)testTableName);
        ClientTestUtil.loadDefaultTable((KuduClient)this.client, (String)testTableName, (int)100);
        KuduScanToken.KuduScanTokenBuilder builder = new KuduScanToken.KuduScanTokenBuilder(this.asyncClient, table);
        builder.scanRequestTimeout(20L);
        List tokens = builder.build();
        for (KuduScanToken token : tokens) {
            byte[] serialized = token.serialize();
            KuduScanner scanner = KuduScanToken.deserializeIntoScanner((byte[])serialized, (KuduClient)this.client);
            Assert.assertEquals((long)20L, (long)scanner.getScanRequestTimeout());
        }
    }

    private long setupTableForDiffScans(KuduClient client, KuduTable table, int numRows) throws Exception {
        int i;
        KuduSession session = client.newSession();
        for (int i2 = 0; i2 < numRows / 2; ++i2) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i2));
        }
        long timestamp = client.getLastPropagatedTimestamp();
        for (i = numRows / 2; i < numRows; ++i) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i));
        }
        for (i = 0; i < numRows / 4; ++i) {
            Delete delete = table.newDelete();
            PartialRow row = delete.getRow();
            row.addInt(0, i);
            session.apply((Operation)delete);
        }
        return timestamp;
    }

    private void checkDiffScanResults(KuduScanner scanner, int numExpectedMutations, int numExpectedDeletes) throws KuduException {
        int numMutations = 0;
        int numDeletes = 0;
        while (scanner.hasMoreRows()) {
            for (RowResult rowResult : scanner.nextRows()) {
                ++numMutations;
                if (!rowResult.isDeleted()) continue;
                ++numDeletes;
            }
        }
        Assert.assertEquals((long)numExpectedMutations, (long)numMutations);
        Assert.assertEquals((long)numExpectedDeletes, (long)numDeletes);
    }

    @Test
    public void testDiffScanTokens() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        int numRows = 20;
        long timestamp = this.setupTableForDiffScans(this.client, table, numRows);
        List tokens = ((KuduScanToken.KuduScanTokenBuilder)this.client.newScanTokenBuilder(table).includeTableMetadata(false).diffScan(timestamp + 1L, this.client.getLastPropagatedTimestamp() + 1L)).build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        this.checkDiffScanResults(((KuduScanToken)tokens.get(0)).intoScanner(this.client), 3 * numRows / 4, numRows / 4);
    }

    @Test
    public void testDiffScanTokensConcurrentColumnRename() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        int numRows = 20;
        long timestamp = this.setupTableForDiffScans(this.client, table, numRows);
        List tokens = ((KuduScanToken.KuduScanTokenBuilder)this.client.newScanTokenBuilder(table).includeTableMetadata(false).diffScan(timestamp + 1L, this.client.getLastPropagatedTimestamp() + 1L)).build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        this.client.alterTable(table.getName(), new AlterTableOptions().renameColumn("column1_i", "column1_i_new"));
        KuduScanner scanner = ((KuduScanToken)tokens.get(0)).intoScanner(this.client);
        this.checkDiffScanResults(scanner, 3 * numRows / 4, numRows / 4);
    }

    @Test
    public void testScanTokenRequestsWithMetadata() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        KuduClient newClient = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
        newClient.getTablesList();
        Assert.assertNull((Object)newClient.asyncClient.getAuthzTokenCache().get(table.getTableId()));
        KuduMetrics.logMetrics();
        long beforeRequests = MetricTestUtils.totalRequestCount();
        KuduScanToken token = (KuduScanToken)MetricTestUtils.validateRequestCount((int)1, (String)this.client.getClientId(), (String)"GetTableLocations", () -> {
            KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
            List tokens = tokenBuilder.includeTableMetadata(true).build();
            Assert.assertEquals((long)1L, (long)tokens.size());
            return (KuduScanToken)tokens.get(0);
        });
        KuduScanner scanner = (KuduScanner)MetricTestUtils.validateRequestCount((int)0, (String)newClient.getClientId(), () -> token.intoScanner(newClient));
        Assert.assertNotNull((Object)newClient.asyncClient.getAuthzTokenCache().get(table.getTableId()));
        MetricTestUtils.validateRequestCount((int)1, (String)newClient.getClientId(), (String)"Scan", () -> ((KuduScanner)scanner).nextRows());
        long afterRequests = MetricTestUtils.totalRequestCount();
        KuduMetrics.logMetrics();
        Assert.assertEquals((long)2L, (long)(afterRequests - beforeRequests));
    }

    @Test
    public void testScanTokenRequestsNoMetadata() throws Exception {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        KuduClient newClient = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
        newClient.getTablesList();
        KuduMetrics.logMetrics();
        long beforeRequests = MetricTestUtils.totalRequestCount();
        KuduScanToken token = (KuduScanToken)MetricTestUtils.validateRequestCount((int)1, (String)this.client.getClientId(), (String)"GetTableLocations", () -> {
            KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
            List tokens = tokenBuilder.includeTableMetadata(false).includeTabletMetadata(false).build();
            Assert.assertEquals((long)1L, (long)tokens.size());
            return (KuduScanToken)tokens.get(0);
        });
        KuduScanner scanner = (KuduScanner)MetricTestUtils.validateRequestCount((int)1, (String)newClient.getClientId(), (String)"GetTableSchema", () -> token.intoScanner(newClient));
        MetricTestUtils.validateRequestCount((int)2, (String)newClient.getClientId(), Arrays.asList("GetTableLocations", "Scan"), () -> ((KuduScanner)scanner).nextRows());
        long afterRequests = MetricTestUtils.totalRequestCount();
        KuduMetrics.logMetrics();
        Assert.assertEquals((long)4L, (long)(afterRequests - beforeRequests));
    }

    @Test
    public void testScanTokenSize() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.INT8).key(true).build());
        for (int i = 0; i < 100; ++i) {
            columns.add(new ColumnSchema.ColumnSchemaBuilder("int64-" + i, Type.INT64).build());
        }
        Schema schema = new Schema(columns);
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.setRangePartitionColumns((List)ImmutableList.of());
        createOptions.setNumReplicas(1);
        KuduTable table = this.client.createTable(testTableName, schema, createOptions);
        KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
        List tokens = tokenBuilder.includeTabletMetadata(false).includeTableMetadata(false).build();
        Assert.assertEquals((long)1L, (long)tokens.size());
        byte[] tokenBytes = ((KuduScanToken)tokens.get(0)).serialize();
        List tokensWithTabletMetadata = tokenBuilder.includeTabletMetadata(true).includeTableMetadata(false).build();
        Assert.assertEquals((long)1L, (long)tokensWithTabletMetadata.size());
        byte[] tokenWithTabletMetadataBytes = ((KuduScanToken)tokensWithTabletMetadata.get(0)).serialize();
        List tokensWithTableMetadata = tokenBuilder.includeTabletMetadata(false).includeTableMetadata(true).build();
        Assert.assertEquals((long)1L, (long)tokensWithTabletMetadata.size());
        byte[] tokenWithTableMetadataBytes = ((KuduScanToken)tokensWithTableMetadata.get(0)).serialize();
        List tokensWithAllMetadata = tokenBuilder.includeTabletMetadata(true).includeTableMetadata(true).build();
        Assert.assertEquals((long)1L, (long)tokensWithAllMetadata.size());
        byte[] tokenWithAllMetadataBytes = ((KuduScanToken)tokensWithAllMetadata.get(0)).serialize();
        LOG.info("tokenBytes: " + tokenBytes.length);
        LOG.info("tokenWithTabletMetadataBytes: " + tokenWithTabletMetadataBytes.length);
        LOG.info("tokenWithTableMetadataBytes: " + tokenWithTableMetadataBytes.length);
        LOG.info("tokenWithAllMetadataBytes: " + tokenWithAllMetadataBytes.length);
        Assert.assertTrue((tokenWithAllMetadataBytes.length > tokenWithTableMetadataBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((tokenWithTableMetadataBytes.length > tokenWithTabletMetadataBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((tokenWithTabletMetadataBytes.length > tokenBytes.length ? 1 : 0) != 0);
    }
}

