/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.util.CharUtil;
import org.apache.kudu.util.DecimalUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestScanPredicate {
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    private Schema createTableSchema(Type type) {
        ColumnSchema val;
        ColumnSchema key = new ColumnSchema.ColumnSchemaBuilder("key", Type.INT64).key(true).build();
        switch (type) {
            case VARCHAR: {
                val = new ColumnSchema.ColumnSchemaBuilder("value", type).typeAttributes(CharUtil.typeAttributes((int)10)).nullable(true).build();
                break;
            }
            default: {
                val = new ColumnSchema.ColumnSchemaBuilder("value", type).nullable(true).build();
            }
        }
        return new Schema((List)ImmutableList.of((Object)key, (Object)val));
    }

    private static CreateTableOptions createTableOptions() {
        return new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of((Object)"key"));
    }

    private int countRows(KuduTable table, KuduPredicate ... predicates) throws Exception {
        KuduScanner.KuduScannerBuilder scanBuilder = new KuduScanner.KuduScannerBuilder(this.asyncClient, table);
        for (KuduPredicate predicate : predicates) {
            scanBuilder.addPredicate(predicate);
        }
        KuduScanner scanner = scanBuilder.build();
        int count = 0;
        while (scanner.hasMoreRows()) {
            count += scanner.nextRows().getNumRows();
        }
        return count;
    }

    private NavigableSet<Long> createIntegerValues(Type type) {
        TreeSet<Long> values = new TreeSet<Long>();
        for (long i = -50L; i < 50L; ++i) {
            values.add(i);
        }
        values.add(KuduPredicate.minIntValue((Type)type));
        values.add(KuduPredicate.minIntValue((Type)type) + 1L);
        values.add(KuduPredicate.maxIntValue((Type)type) - 1L);
        values.add(KuduPredicate.maxIntValue((Type)type));
        return values;
    }

    private List<Long> createIntegerTestValues(Type type) {
        return ImmutableList.of((Object)KuduPredicate.minIntValue((Type)type), (Object)(KuduPredicate.minIntValue((Type)type) + 1L), (Object)-51L, (Object)50L, (Object)0L, (Object)49L, (Object)50L, (Object)(KuduPredicate.maxIntValue((Type)type) - 1L), (Object)KuduPredicate.maxIntValue((Type)type));
    }

    private NavigableSet<Float> createFloatValues() {
        TreeSet<Float> values = new TreeSet<Float>();
        for (long i = -50L; i < 50L; ++i) {
            values.add(Float.valueOf((float)i + (float)i / 100.0f));
        }
        values.add(Float.valueOf(Float.NEGATIVE_INFINITY));
        values.add(Float.valueOf(-3.4028235E38f));
        values.add(Float.valueOf(-1.1754944E-38f));
        values.add(Float.valueOf(-1.4E-45f));
        values.add(Float.valueOf(Float.MIN_VALUE));
        values.add(Float.valueOf(Float.MIN_NORMAL));
        values.add(Float.valueOf(Float.MAX_VALUE));
        values.add(Float.valueOf(Float.POSITIVE_INFINITY));
        return values;
    }

    private List<Float> createFloatTestValues() {
        return ImmutableList.of((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(-3.4028235E38f), (Object)Float.valueOf(-100.0f), (Object)Float.valueOf(-1.1f), (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(-1.1754944E-38f), (Object)Float.valueOf(-1.4E-45f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(Float.MIN_NORMAL), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.1f), (Object[])new Float[]{Float.valueOf(100.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY)});
    }

    private NavigableSet<Double> createDoubleValues() {
        TreeSet<Double> values = new TreeSet<Double>();
        for (long i = -50L; i < 50L; ++i) {
            values.add((double)i + (double)i / 100.0);
        }
        values.add(Double.NEGATIVE_INFINITY);
        values.add(-1.7976931348623157E308);
        values.add(-2.2250738585072014E-308);
        values.add(-4.9E-324);
        values.add((Double)Double.MIN_VALUE);
        values.add((Double)Double.MIN_NORMAL);
        values.add((Double)Double.MAX_VALUE);
        values.add(Double.POSITIVE_INFINITY);
        return values;
    }

    private List<Double> createDoubleTestValues() {
        return ImmutableList.of((Object)Double.NEGATIVE_INFINITY, (Object)-1.7976931348623157E308, (Object)-100.0, (Object)-1.1, (Object)-1.0, (Object)-2.2250738585072014E-308, (Object)-4.9E-324, (Object)0.0, (Object)Double.MIN_VALUE, (Object)Double.MIN_NORMAL, (Object)1.0, (Object)1.1, (Object[])new Double[]{100.0, Double.MAX_VALUE, Double.POSITIVE_INFINITY});
    }

    private NavigableSet<BigDecimal> createDecimalValues() {
        TreeSet<BigDecimal> values = new TreeSet<BigDecimal>();
        for (long i = -50L; i < 50L; ++i) {
            values.add(BigDecimal.valueOf(i * 100L + i, 2));
        }
        values.add(BigDecimal.valueOf(-9999L, 2));
        values.add(BigDecimal.valueOf(-9998L, 2));
        values.add(BigDecimal.valueOf(9998L, 2));
        values.add(BigDecimal.valueOf(9999L, 2));
        return values;
    }

    private List<BigDecimal> createDecimalTestValues() {
        return ImmutableList.of((Object)BigDecimal.valueOf(-9999L, 2), (Object)BigDecimal.valueOf(-9998L, 2), (Object)BigDecimal.valueOf(5100L, 2), (Object)BigDecimal.valueOf(-5000L, 2), (Object)BigDecimal.valueOf(0L, 2), (Object)BigDecimal.valueOf(4900L, 2), (Object)BigDecimal.valueOf(5000L, 2), (Object)BigDecimal.valueOf(9998L, 2), (Object)BigDecimal.valueOf(9999L, 2));
    }

    private NavigableSet<String> createStringValues() {
        return ImmutableSortedSet.of((Comparable)((Object)""), (Comparable)((Object)"\u0000"), (Comparable)((Object)"\u0000\u0000"), (Comparable)((Object)"a"), (Comparable)((Object)"a\u0000"), (Comparable)((Object)"a\u0000a"), (Comparable[])new String[]{"aa\u0000"});
    }

    private List<String> createStringTestValues() {
        ArrayList<String> values = new ArrayList<String>(this.createStringValues());
        values.add("aa");
        values.add("\u0001");
        values.add("a\u0001");
        return values;
    }

    private void checkIntPredicates(KuduTable table, NavigableSet<Long> values, List<Long> testValues) throws Exception {
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        for (long v : testValues) {
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)v);
            Assert.assertEquals((long)(values.contains(v) ? 1L : 0L), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)v);
            Assert.assertEquals((long)values.tailSet(v).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (long)v);
            Assert.assertEquals((long)values.headSet(v, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (long)v);
            Assert.assertEquals((long)values.tailSet(v, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)v);
            Assert.assertEquals((long)values.headSet(v).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }

    @Test
    public void testBoolPredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.BOOL);
        this.client.createTable("bool-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("bool-table");
        ImmutableSortedSet values = ImmutableSortedSet.of((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true));
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            boolean value = (Boolean)iterator.next();
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addBoolean("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        Iterator iterator2 = values.iterator();
        while (iterator2.hasNext()) {
            boolean v = (Boolean)iterator2.next();
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (boolean)v);
            Assert.assertEquals((long)(values.contains(v) ? 1L : 0L), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (boolean)v);
            Assert.assertEquals((long)values.tailSet(v).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (boolean)v);
            Assert.assertEquals((long)values.headSet(v, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (boolean)v);
            Assert.assertEquals((long)values.tailSet(v, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (boolean)v);
            Assert.assertEquals((long)values.headSet(v).size(), (long)this.countRows(table, less));
        }
    }

    @Test
    public void testBytePredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.INT8);
        this.client.createTable("byte-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("byte-table");
        NavigableSet<Long> values = this.createIntegerValues(Type.INT8);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (long value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addByte("value", (byte)value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        this.checkIntPredicates(table, values, this.createIntegerTestValues(Type.INT8));
    }

    @Test
    public void testShortPredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.INT16);
        this.client.createTable("short-table", schema, new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of()));
        KuduTable table = this.client.openTable("short-table");
        NavigableSet<Long> values = this.createIntegerValues(Type.INT16);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (long value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addShort("value", (short)value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        this.checkIntPredicates(table, values, this.createIntegerTestValues(Type.INT16));
    }

    @Test
    public void testIntPredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.INT32);
        this.client.createTable("int-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("int-table");
        NavigableSet<Long> values = this.createIntegerValues(Type.INT32);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (long value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addInt("value", (int)value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        this.checkIntPredicates(table, values, this.createIntegerTestValues(Type.INT32));
    }

    @Test
    public void testLongPredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.INT64);
        this.client.createTable("long-table", schema, new CreateTableOptions().setRangePartitionColumns((List)ImmutableList.of()));
        KuduTable table = this.client.openTable("long-table");
        NavigableSet<Long> values = this.createIntegerValues(Type.INT64);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (long value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addLong("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        this.checkIntPredicates(table, values, this.createIntegerTestValues(Type.INT64));
    }

    @Test
    public void testTimestampPredicate() throws Exception {
        Schema schema = this.createTableSchema(Type.INT64);
        this.client.createTable("timestamp-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("timestamp-table");
        NavigableSet<Long> values = this.createIntegerValues(Type.INT64);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (long value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addLong("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        this.checkIntPredicates(table, values, this.createIntegerTestValues(Type.INT64));
    }

    @Test
    public void testFloatPredicates() throws Exception {
        Object insert;
        Schema schema = this.createTableSchema(Type.FLOAT);
        this.client.createTable("float-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("float-table");
        NavigableSet<Float> values = this.createFloatValues();
        List<Float> testValues = this.createFloatTestValues();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (float value : values) {
            insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addFloat("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        insert = testValues.iterator();
        while (insert.hasNext()) {
            float v = ((Float)insert.next()).floatValue();
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (float)v);
            Assert.assertEquals((long)values.subSet(Float.valueOf(v), true, Float.valueOf(v), true).size(), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (float)v);
            Assert.assertEquals((long)values.tailSet(Float.valueOf(v)).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (float)v);
            Assert.assertEquals((long)values.headSet(Float.valueOf(v), true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (float)v);
            Assert.assertEquals((long)values.tailSet(Float.valueOf(v), false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (float)v);
            Assert.assertEquals((long)values.headSet(Float.valueOf(v)).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }

    @Test
    public void testDoublePredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.DOUBLE);
        this.client.createTable("double-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("double-table");
        NavigableSet<Double> values = this.createDoubleValues();
        List<Double> testValues = this.createDoubleTestValues();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (double value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addDouble("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        for (double v : testValues) {
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (double)v);
            Assert.assertEquals((long)values.subSet(v, true, v, true).size(), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (double)v);
            Assert.assertEquals((long)values.tailSet(v).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (double)v);
            Assert.assertEquals((long)values.headSet(v, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (double)v);
            Assert.assertEquals((long)values.tailSet(v, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (double)v);
            Assert.assertEquals((long)values.headSet(v).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }

    @Test
    public void testDecimalPredicates() throws Exception {
        ColumnSchema key = new ColumnSchema.ColumnSchemaBuilder("key", Type.INT64).key(true).build();
        ColumnSchema val = new ColumnSchema.ColumnSchemaBuilder("value", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)4, (int)2)).nullable(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)key, (Object)val));
        this.client.createTable("decimal-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("decimal-table");
        NavigableSet<BigDecimal> values = this.createDecimalValues();
        List<BigDecimal> testValues = this.createDecimalTestValues();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (BigDecimal value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addDecimal("value", value);
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        for (BigDecimal v : testValues) {
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (BigDecimal)v);
            Assert.assertEquals((long)values.subSet(v, true, v, true).size(), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (BigDecimal)v);
            Assert.assertEquals((long)values.tailSet(v).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (BigDecimal)v);
            Assert.assertEquals((long)values.headSet(v, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (BigDecimal)v);
            Assert.assertEquals((long)values.tailSet(v, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (BigDecimal)v);
            Assert.assertEquals((long)values.headSet(v).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }

    @Test
    public void testStringPredicates() throws Exception {
        this.testVarlengthPredicates(Type.STRING);
    }

    @Test
    public void testVarcharPredicates() throws Exception {
        this.testVarlengthPredicates(Type.VARCHAR);
    }

    private void testVarlengthPredicates(Type type) throws Exception {
        Schema schema = this.createTableSchema(type);
        this.client.createTable("string-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("string-table");
        NavigableSet<String> values = this.createStringValues();
        List<String> testValues = this.createStringTestValues();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (String value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            switch (type) {
                case VARCHAR: {
                    insert.getRow().addVarchar("value", value);
                    break;
                }
                case STRING: {
                    insert.getRow().addString("value", value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("CHAR/VARCHAR/STRING expected");
                }
            }
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        for (String v : testValues) {
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)v);
            Assert.assertEquals((long)values.subSet(v, true, v, true).size(), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)v);
            Assert.assertEquals((long)values.tailSet(v).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (String)v);
            Assert.assertEquals((long)values.headSet(v, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (String)v);
            Assert.assertEquals((long)values.tailSet(v, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)v);
            Assert.assertEquals((long)values.headSet(v).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }

    @Test
    public void testBinaryPredicates() throws Exception {
        Schema schema = this.createTableSchema(Type.BINARY);
        this.client.createTable("binary-table", schema, TestScanPredicate.createTableOptions());
        KuduTable table = this.client.openTable("binary-table");
        NavigableSet<String> values = this.createStringValues();
        List<String> testValues = this.createStringTestValues();
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        long i = 0L;
        for (String value : values) {
            Insert insert = table.newInsert();
            insert.getRow().addLong("key", i++);
            insert.getRow().addBinary("value", Bytes.fromString((String)value));
            session.apply((Operation)insert);
        }
        Insert nullInsert = table.newInsert();
        nullInsert.getRow().addLong("key", i);
        nullInsert.getRow().setNull("value");
        session.apply((Operation)nullInsert);
        session.flush();
        ColumnSchema col = table.getSchema().getColumn("value");
        Assert.assertEquals((long)(values.size() + 1), (long)this.countRows(table, new KuduPredicate[0]));
        for (String s : testValues) {
            byte[] v = Bytes.fromString((String)s);
            KuduPredicate equal = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (byte[])v);
            Assert.assertEquals((long)values.subSet(s, true, s, true).size(), (long)this.countRows(table, equal));
            KuduPredicate greaterEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (byte[])v);
            Assert.assertEquals((long)values.tailSet(s).size(), (long)this.countRows(table, greaterEqual));
            KuduPredicate lessEqual = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS_EQUAL, (byte[])v);
            Assert.assertEquals((long)values.headSet(s, true).size(), (long)this.countRows(table, lessEqual));
            KuduPredicate greater = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER, (byte[])v);
            Assert.assertEquals((long)values.tailSet(s, false).size(), (long)this.countRows(table, greater));
            KuduPredicate less = KuduPredicate.newComparisonPredicate((ColumnSchema)col, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (byte[])v);
            Assert.assertEquals((long)values.headSet(s).size(), (long)this.countRows(table, less));
        }
        KuduPredicate isNotNull = KuduPredicate.newIsNotNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)values.size(), (long)this.countRows(table, isNotNull));
        KuduPredicate isNull = KuduPredicate.newIsNullPredicate((ColumnSchema)col);
        Assert.assertEquals((long)1L, (long)this.countRows(table, isNull));
    }
}

