/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.PingRequest;
import org.apache.kudu.client.RpcTraceFrame;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.Status;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestRpcTraces {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testLimit() {
        PingRequest ping = PingRequest.makeMasterPingRequest();
        ping.addTrace(this.getTrace());
        this.assertNotTruncated((KuduRpc<?>)ping);
        for (int i = 0; i < 98; ++i) {
            ping.addTrace(this.getTrace());
        }
        this.assertNotTruncated((KuduRpc<?>)ping);
        ping.addTrace(this.getTrace());
        this.assertNotTruncated((KuduRpc<?>)ping);
        ping.addTrace(this.getTrace());
        this.assertTruncateIsLast((KuduRpc<?>)ping);
        ping.addTrace(this.getTrace());
        this.assertTruncateIsLast((KuduRpc<?>)ping);
    }

    @Test
    public void testParentRpc() {
        PingRequest parent = PingRequest.makeMasterPingRequest();
        PingRequest daughter = PingRequest.makeMasterPingRequest();
        PingRequest son = PingRequest.makeMasterPingRequest();
        PingRequest sonsDaughter = PingRequest.makeMasterPingRequest();
        sonsDaughter.setParentRpc((KuduRpc)son);
        son.setParentRpc((KuduRpc)parent);
        daughter.setParentRpc((KuduRpc)parent);
        RpcTraceFrame trace = this.getTrace();
        sonsDaughter.addTrace(trace);
        Assert.assertSame((Object)trace, son.getImmutableTraces().get(0));
        Assert.assertTrue((parent.getImmutableTraces().get(0) == trace ? 1 : 0) != 0);
        Assert.assertTrue((boolean)daughter.getImmutableTraces().isEmpty());
        trace = this.getTrace();
        son.addTrace(trace);
        Assert.assertSame((Object)trace, son.getImmutableTraces().get(1));
        Assert.assertSame((Object)trace, parent.getImmutableTraces().get(1));
        Assert.assertTrue((boolean)daughter.getImmutableTraces().isEmpty());
        Assert.assertEquals((long)1L, (long)sonsDaughter.getImmutableTraces().size());
        trace = this.getTrace();
        daughter.addTrace(trace);
        Assert.assertSame((Object)trace, daughter.getImmutableTraces().get(0));
        Assert.assertSame((Object)trace, parent.getImmutableTraces().get(2));
        Assert.assertEquals((long)2L, (long)son.getImmutableTraces().size());
        Assert.assertEquals((long)1L, (long)sonsDaughter.getImmutableTraces().size());
        trace = this.getTrace();
        parent.addTrace(trace);
        Assert.assertSame((Object)trace, parent.getImmutableTraces().get(3));
        Assert.assertEquals((long)1L, (long)daughter.getImmutableTraces().size());
        Assert.assertEquals((long)2L, (long)son.getImmutableTraces().size());
        Assert.assertEquals((long)1L, (long)sonsDaughter.getImmutableTraces().size());
    }

    @Test
    public void testTraceSummary() throws Exception {
        ArrayList<RpcTraceFrame> traces = new ArrayList<RpcTraceFrame>();
        String emptySummary = RpcTraceFrame.getHumanReadableSummaryStringForTraces(traces);
        Assert.assertEquals((Object)"No traces", (Object)emptySummary);
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("GetTableLocations", RpcTraceFrame.Action.QUERY_MASTER).build());
        String summary1 = RpcTraceFrame.getHumanReadableSummaryStringForTraces(traces);
        Assert.assertTrue((boolean)summary1.contains("Sent(0)"));
        Assert.assertTrue((boolean)summary1.contains("Received(0)"));
        Assert.assertTrue((boolean)summary1.contains("Delayed(0)"));
        Assert.assertTrue((boolean)summary1.contains("MasterRefresh(1)"));
        Assert.assertTrue((boolean)summary1.contains("AuthRefresh(0)"));
        Assert.assertTrue((boolean)summary1.contains("Truncated: false"));
        Assert.assertFalse((boolean)summary1.contains("Sent:"));
        Assert.assertFalse((boolean)summary1.contains("Received:"));
        Assert.assertFalse((boolean)summary1.contains("Delayed:"));
        ServerInfo serverInfo = new ServerInfo("fake-uuid", new HostAndPort("test.com", 12345), InetAddress.getByName("10.1.2.3"), "");
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.SEND_TO_SERVER).build());
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.SEND_TO_SERVER).serverInfo(serverInfo).build());
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.RECEIVE_FROM_SERVER).build());
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.RECEIVE_FROM_SERVER).serverInfo(serverInfo).callStatus(Status.OK()).build());
        String summary2 = RpcTraceFrame.getHumanReadableSummaryStringForTraces(traces);
        Assert.assertTrue((boolean)summary2.contains("Sent(2)"));
        Assert.assertTrue((boolean)summary2.contains("Received(2)"));
        Assert.assertTrue((boolean)summary2.contains("Delayed(0)"));
        Assert.assertTrue((boolean)summary2.contains("MasterRefresh(1)"));
        Assert.assertTrue((boolean)summary2.contains("AuthRefresh(0)"));
        Assert.assertTrue((boolean)summary2.contains("Truncated: false"));
        Assert.assertTrue((boolean)summary2.contains("Sent: (UNKNOWN, [ Batch, 1 ]), (fake-uuid, [ Batch, 1 ])"));
        Assert.assertTrue((boolean)summary2.contains("Received: (UNKNOWN, [ UNKNOWN, 1 ]), (fake-uuid, [ OK, 1 ])"));
        Assert.assertFalse((boolean)summary2.contains("Delayed:"));
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.SLEEP_THEN_RETRY).serverInfo(serverInfo).build());
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.GET_NEW_AUTHENTICATION_TOKEN_THEN_RETRY).serverInfo(serverInfo).build());
        String summary3 = RpcTraceFrame.getHumanReadableSummaryStringForTraces(traces);
        Assert.assertTrue((boolean)summary3.contains("Sent(2)"));
        Assert.assertTrue((boolean)summary3.contains("Received(2)"));
        Assert.assertTrue((boolean)summary3.contains("Delayed(1)"));
        Assert.assertTrue((boolean)summary3.contains("MasterRefresh(1)"));
        Assert.assertTrue((boolean)summary3.contains("AuthRefresh(1)"));
        Assert.assertTrue((boolean)summary3.contains("Truncated: false"));
        Assert.assertFalse((boolean)summary2.contains("Delayed: (fake-uuid, [ Batch, 1 ])"));
        traces.add(new RpcTraceFrame.RpcTraceFrameBuilder("Batch", RpcTraceFrame.Action.TRACE_TRUNCATED).build());
        String summary4 = RpcTraceFrame.getHumanReadableSummaryStringForTraces(traces);
        Assert.assertTrue((boolean)summary4.contains("Truncated: true"));
    }

    private RpcTraceFrame getTrace() {
        return new RpcTraceFrame.RpcTraceFrameBuilder("trace", RpcTraceFrame.Action.QUERY_MASTER).build();
    }

    private void assertNotTruncated(KuduRpc<?> rpc) {
        for (RpcTraceFrame trace : rpc.getImmutableTraces()) {
            Assert.assertNotEquals((Object)RpcTraceFrame.Action.TRACE_TRUNCATED, (Object)trace.getAction());
        }
    }

    private void assertTruncateIsLast(KuduRpc<?> rpc) {
        List traces = rpc.getImmutableTraces();
        Assert.assertEquals((long)101L, (long)traces.size());
        for (int i = 0; i < traces.size() - 1; ++i) {
            Assert.assertNotEquals((Object)RpcTraceFrame.Action.TRACE_TRUNCATED, (Object)((RpcTraceFrame)traces.get(i)).getAction());
        }
        Assert.assertEquals((Object)RpcTraceFrame.Action.TRACE_TRUNCATED, (Object)((RpcTraceFrame)traces.get(traces.size() - 1)).getAction());
    }
}

