/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestPartitionPruner {
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
    }

    private void checkPartitionsPrimaryKey(int expectedTablets, KuduTable table, List<Partition> partitions, byte[] lowerBoundPrimaryKey, byte[] upperBoundPrimaryKey) throws Exception {
        int i;
        KuduScanToken.KuduScanTokenBuilder scanBuilder = this.client.newScanTokenBuilder(table);
        if (lowerBoundPrimaryKey != null) {
            PartialRow lower = table.getSchema().newPartialRow();
            for (i = 0; i < 3; ++i) {
                lower.addByte(i, lowerBoundPrimaryKey[i]);
            }
            scanBuilder.lowerBound(lower);
        }
        if (upperBoundPrimaryKey != null) {
            PartialRow upper = table.getSchema().newPartialRow();
            for (i = 0; i < 3; ++i) {
                upper.addByte(i, upperBoundPrimaryKey[i]);
            }
            scanBuilder.exclusiveUpperBound(upper);
        }
        PartitionPruner pruner = PartitionPruner.create((AbstractKuduScannerBuilder)scanBuilder);
        int scannedPartitions = 0;
        for (Partition partition : partitions) {
            if (pruner.shouldPruneForTests(partition)) continue;
            ++scannedPartitions;
        }
        Assert.assertEquals((long)expectedTablets, (long)scannedPartitions);
        Assert.assertEquals((long)scannedPartitions, (long)scanBuilder.build().size());
        Assert.assertEquals((long)(expectedTablets == 0 ? 0L : 1L), (long)pruner.numRangesRemainingForTests());
    }

    private void checkPartitions(int expectedTablets, int expectedPrunerRanges, KuduTable table, List<Partition> partitions, KuduPredicate ... predicates) {
        this.checkPartitions(expectedTablets, expectedPrunerRanges, table, partitions, (byte[])null, (byte[])null, predicates);
    }

    private void checkPartitions(int expectedTablets, int expectedPrunerRanges, KuduTable table, List<Partition> partitions, byte[] lowerBoundPartitionKey, byte[] upperBoundPartitionKey, KuduPredicate ... predicates) {
        KuduScanner.KuduScannerBuilder scanBuilder = this.client.newScannerBuilder(table);
        for (KuduPredicate predicate : predicates) {
            scanBuilder.addPredicate(predicate);
        }
        if (lowerBoundPartitionKey != null) {
            scanBuilder.lowerBoundPartitionKeyRaw(lowerBoundPartitionKey);
        }
        if (upperBoundPartitionKey != null) {
            scanBuilder.exclusiveUpperBoundPartitionKeyRaw(upperBoundPartitionKey);
        }
        PartitionPruner pruner = PartitionPruner.create((AbstractKuduScannerBuilder)scanBuilder);
        int scannedPartitions = 0;
        for (Partition partition : partitions) {
            if (pruner.shouldPruneForTests(partition)) continue;
            ++scannedPartitions;
        }
        Assert.assertEquals((long)expectedTablets, (long)scannedPartitions);
        Assert.assertEquals((long)expectedPrunerRanges, (long)pruner.numRangesRemainingForTests());
        if (lowerBoundPartitionKey == null && upperBoundPartitionKey == null) {
            KuduScanToken.KuduScanTokenBuilder tokenBuilder = this.client.newScanTokenBuilder(table);
            for (KuduPredicate predicate : predicates) {
                tokenBuilder.addPredicate(predicate);
            }
            Assert.assertEquals((long)expectedTablets, (long)tokenBuilder.build().size());
        }
    }

    private List<Partition> getTablePartitions(KuduTable table) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (KuduScanToken token : this.client.newScanTokenBuilder(table).build()) {
            partitions.add(token.getTablet().getPartition());
        }
        return partitions;
    }

    @Test
    public void testPrimaryKeyRangePruning() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(3);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build());
        Schema schema = new Schema(columns);
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        PartialRow split = schema.newPartialRow();
        split.addByte("a", (byte)0);
        split.addByte("b", (byte)0);
        split.addByte("c", (byte)0);
        tableBuilder.addSplitRow(split);
        split.addByte("a", (byte)10);
        split.addByte("b", (byte)10);
        split.addByte("c", (byte)10);
        tableBuilder.addSplitRow(split);
        String tableName = "testPrimaryKeyRangePruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        byte min = -128;
        this.checkPartitionsPrimaryKey(3, table, partitions, null, null);
        this.checkPartitionsPrimaryKey(1, table, partitions, null, new byte[]{-1, min, min});
        this.checkPartitionsPrimaryKey(1, table, partitions, null, new byte[]{0, 0, 0});
        this.checkPartitionsPrimaryKey(1, table, partitions, null, new byte[]{0, 0, min});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{10, 10, 10});
        this.checkPartitionsPrimaryKey(3, table, partitions, null, new byte[]{100, min, min});
        this.checkPartitionsPrimaryKey(3, table, partitions, new byte[]{-10, -10, -10}, null);
        this.checkPartitionsPrimaryKey(2, table, partitions, new byte[]{0, 0, 0}, null);
        this.checkPartitionsPrimaryKey(1, table, partitions, new byte[]{100, 0, 0}, null);
        this.checkPartitionsPrimaryKey(3, table, partitions, new byte[]{-10, 0, 0}, new byte[]{100, 0, 0});
        this.checkPartitionsPrimaryKey(1, table, partitions, new byte[]{0, 0, 0}, new byte[]{10, 0, 0});
        this.checkPartitionsPrimaryKey(1, table, partitions, new byte[]{0, 0, 0}, new byte[]{10, 0, 0});
        this.checkPartitionsPrimaryKey(0, table, partitions, new byte[]{10, 0, 0}, new byte[]{0, 0, 0});
    }

    @Test
    public void testPrimaryKeyPrefixRangePruning() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(3);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build());
        Schema schema = new Schema(columns);
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b"));
        PartialRow split = schema.newPartialRow();
        split.addByte("a", (byte)0);
        split.addByte("b", (byte)0);
        tableBuilder.addSplitRow(split);
        String tableName = "testPrimaryKeyPrefixRangePruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        int min = -128;
        int max = 127;
        this.checkPartitionsPrimaryKey(2, table, partitions, null, null);
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{-1, -128, -128});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{0, 0, -128});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{0, 0, 0});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{0, 1, -128});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{0, 1, 0});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{127, 127, -128});
        this.checkPartitionsPrimaryKey(2, table, partitions, null, new byte[]{127, 127, 0});
        this.checkPartitionsPrimaryKey(2, table, partitions, new byte[]{0, 0, -128}, null);
        this.checkPartitionsPrimaryKey(2, table, partitions, new byte[]{0, 0, 0}, null);
        this.checkPartitionsPrimaryKey(2, table, partitions, new byte[]{0, -1, 0}, null);
    }

    @Test
    public void testRangePartitionPruning() throws Exception {
        ColumnSchema a = new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build();
        ColumnSchema b = new ColumnSchema.ColumnSchemaBuilder("b", Type.STRING).key(true).build();
        ColumnSchema c = new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)a, (Object)b, (Object)c));
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"c", (Object)"b"));
        PartialRow split = schema.newPartialRow();
        split.addByte("c", (byte)0);
        split.addString("b", "m");
        tableBuilder.addSplitRow(split);
        split.addByte("c", (byte)10);
        split.addString("b", "r");
        tableBuilder.addSplitRow(split);
        String tableName = "testRangePartitionPruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        this.checkPartitions(3, 1, table, partitions, new KuduPredicate[0]);
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-10L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)-10L));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)100L));
        this.checkPartitions(0, 0, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)-128L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)127L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-10L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-10L));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)100L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-128L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)127L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)-10L), KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)5L), KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)100L));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)""));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"z"));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"a"));
        this.checkPartitions(3, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"m"), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"z"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (String)"r"));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"r"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"r"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"m"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"z"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"m\u0000"));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"m"));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"m\u0000"));
        this.checkPartitions(0, 0, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)2L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)-128L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)127L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)1, (Object)2)));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1, (Object)2)));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)-10, (Object)0)), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"m"));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)-10, (Object)0)), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (String)"m\u0000"));
    }

    @Test
    public void testHashPartitionPruning() throws Exception {
        ColumnSchema a = new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build();
        ColumnSchema b = new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build();
        ColumnSchema c = new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)a, (Object)b, (Object)c));
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns(new ArrayList());
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a"), 2);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"b", (Object)"c"), 2);
        String tableName = "testHashPartitionPruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        this.checkPartitions(4, 1, table, partitions, new KuduPredicate[0]);
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L));
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)1L));
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)2L));
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L));
        this.checkPartitions(2, 2, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L), KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)2L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)a, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L), KuduPredicate.newComparisonPredicate((ColumnSchema)c, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)2L));
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)10)));
    }

    @Test
    public void testInListHashPartitionPruning() throws Exception {
        ColumnSchema a = new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build();
        ColumnSchema b = new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build();
        ColumnSchema c = new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)a, (Object)b, (Object)c));
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns(new ArrayList());
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a"), 3);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"b"), 3);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"c"), 3);
        String tableName = "testInListHashPartitionPruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        this.checkPartitions(18, 2, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(27, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1, (Object)8)));
        this.checkPartitions(18, 6, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(18, 18, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(12, 12, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(8, 8, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
    }

    @Test
    public void testMultiColumnInListHashPruning() throws Exception {
        ColumnSchema a = new ColumnSchema.ColumnSchemaBuilder("a", Type.INT8).key(true).build();
        ColumnSchema b = new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build();
        ColumnSchema c = new ColumnSchema.ColumnSchemaBuilder("c", Type.INT8).key(true).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)a, (Object)b, (Object)c));
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns(new ArrayList());
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"a"), 3);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"b", (Object)"c"), 3);
        String tableName = "testMultiColumnInListHashPartitionPruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        this.checkPartitions(6, 2, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(9, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1, (Object)8)));
        this.checkPartitions(9, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(9, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(9, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(3, 3, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)0L), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(6, 6, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)b, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)1L), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
        this.checkPartitions(6, 2, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)a, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)b, (List)ImmutableList.of((Object)0, (Object)1)), KuduPredicate.newInListPredicate((ColumnSchema)c, (List)ImmutableList.of((Object)0, (Object)1)));
    }

    @Test
    public void testPruning() throws Exception {
        ColumnSchema host = new ColumnSchema.ColumnSchemaBuilder("host", Type.STRING).key(true).build();
        ColumnSchema metric = new ColumnSchema.ColumnSchemaBuilder("metric", Type.STRING).key(true).build();
        ColumnSchema timestamp = new ColumnSchema.ColumnSchemaBuilder("timestamp", Type.UNIXTIME_MICROS).key(true).build();
        ColumnSchema value = new ColumnSchema.ColumnSchemaBuilder("value", Type.DOUBLE).build();
        Schema schema = new Schema((List)ImmutableList.of((Object)host, (Object)metric, (Object)timestamp, (Object)value));
        CreateTableOptions tableBuilder = new CreateTableOptions();
        tableBuilder.setRangePartitionColumns((List)ImmutableList.of((Object)"timestamp"));
        PartialRow split = schema.newPartialRow();
        split.addLong("timestamp", 10L);
        tableBuilder.addSplitRow(split);
        tableBuilder.addHashPartitions((List)ImmutableList.of((Object)"host", (Object)"metric"), 2);
        String tableName = "testPruning-" + System.currentTimeMillis();
        this.client.createTable(tableName, schema, tableBuilder);
        KuduTable table = this.client.openTable(tableName);
        List<Partition> partitions = this.getTablePartitions(table);
        this.checkPartitions(4, 1, table, partitions, new KuduPredicate[0]);
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"));
        this.checkPartitions(2, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)9L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)20L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.LESS, (long)10L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.GREATER_EQUAL, (long)10L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)metric, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        byte[] hash1 = new byte[]{0, 0, 0, 1};
        this.checkPartitions(2, 1, table, partitions, null, hash1, new KuduPredicate[0]);
        this.checkPartitions(2, 1, table, partitions, hash1, null, new KuduPredicate[0]);
        this.checkPartitions(1, 1, table, partitions, null, hash1, KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        this.checkPartitions(1, 1, table, partitions, hash1, null, KuduPredicate.newComparisonPredicate((ColumnSchema)timestamp, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (long)10L));
        this.checkPartitions(1, 1, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)timestamp, (List)ImmutableList.of((Object)0L, (Object)9L)), KuduPredicate.newComparisonPredicate((ColumnSchema)host, (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)"a"), KuduPredicate.newInListPredicate((ColumnSchema)metric, (List)ImmutableList.of((Object)"foo", (Object)"baz")));
        this.checkPartitions(2, 2, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)timestamp, (List)ImmutableList.of((Object)10L, (Object)100L)));
        this.checkPartitions(4, 2, table, partitions, KuduPredicate.newInListPredicate((ColumnSchema)timestamp, (List)ImmutableList.of((Object)9L, (Object)10L)));
        this.checkPartitions(4, 1, table, partitions, KuduPredicate.newIsNotNullPredicate((ColumnSchema)timestamp));
        this.checkPartitions(0, 0, table, partitions, KuduPredicate.newIsNullPredicate((ColumnSchema)timestamp));
    }
}

