/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.DateUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestPartialRow {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testGetters() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        Assert.assertEquals((Object)true, (Object)partialRow.getBoolean("bool"));
        Assert.assertEquals((long)42L, (long)partialRow.getByte("int8"));
        Assert.assertEquals((long)43L, (long)partialRow.getShort("int16"));
        Assert.assertEquals((long)44L, (long)partialRow.getInt("int32"));
        Assert.assertEquals((long)45L, (long)partialRow.getLong("int64"));
        Assert.assertEquals((Object)new Timestamp(1234567890L), (Object)partialRow.getTimestamp("timestamp"));
        Assert.assertEquals((Object)Date.valueOf(LocalDate.ofEpochDay(0L)), (Object)partialRow.getDate("date"));
        Assert.assertEquals((float)52.35f, (float)partialRow.getFloat("float"), (float)0.0f);
        Assert.assertEquals((double)53.35, (double)partialRow.getDouble("double"), (double)0.0);
        Assert.assertEquals((Object)"fun with \u00fctf\u0000", (Object)partialRow.getString("string"));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4}, (byte[])partialRow.getBinaryCopy("binary-array"));
        Assert.assertArrayEquals((byte[])new byte[]{5, 6, 7, 8, 9}, (byte[])partialRow.getBinaryCopy("binary-bytebuffer"));
        Assert.assertEquals((Object)ByteBuffer.wrap(new byte[]{0, 1, 2, 3, 4}), (Object)partialRow.getBinary("binary-array"));
        Assert.assertEquals((Object)ByteBuffer.wrap(new byte[]{5, 6, 7, 8, 9}), (Object)partialRow.getBinary("binary-bytebuffer"));
        Assert.assertTrue((boolean)partialRow.isSet("null"));
        Assert.assertTrue((boolean)partialRow.isNull("null"));
        Assert.assertEquals((Object)BigDecimal.valueOf(12345L, 3), (Object)partialRow.getDecimal("decimal"));
    }

    @Test
    public void testGetObject() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        Assert.assertTrue((boolean)(partialRow.getObject("bool") instanceof Boolean));
        Assert.assertEquals((Object)true, (Object)partialRow.getObject("bool"));
        Assert.assertTrue((boolean)(partialRow.getObject("int8") instanceof Byte));
        Assert.assertEquals((Object)42, (Object)partialRow.getObject("int8"));
        Assert.assertTrue((boolean)(partialRow.getObject("int16") instanceof Short));
        Assert.assertEquals((Object)43, (Object)partialRow.getObject("int16"));
        Assert.assertTrue((boolean)(partialRow.getObject("int32") instanceof Integer));
        Assert.assertEquals((Object)44, (Object)partialRow.getObject("int32"));
        Assert.assertTrue((boolean)(partialRow.getObject("int64") instanceof Long));
        Assert.assertEquals((Object)45L, (Object)partialRow.getObject("int64"));
        Assert.assertTrue((boolean)(partialRow.getObject("timestamp") instanceof Timestamp));
        Assert.assertEquals((Object)new Timestamp(1234567890L), (Object)partialRow.getObject("timestamp"));
        Assert.assertTrue((boolean)(partialRow.getObject("date") instanceof Date));
        Assert.assertEquals((Object)Date.valueOf(LocalDate.ofEpochDay(0L)), (Object)partialRow.getObject("date"));
        Assert.assertTrue((boolean)(partialRow.getObject("float") instanceof Float));
        Assert.assertEquals((float)52.35f, (float)((Float)partialRow.getObject("float")).floatValue(), (float)0.0f);
        Assert.assertTrue((boolean)(partialRow.getObject("double") instanceof Double));
        Assert.assertEquals((double)53.35, (double)((Double)partialRow.getObject("double")), (double)0.0);
        Assert.assertTrue((boolean)(partialRow.getObject("string") instanceof String));
        Assert.assertEquals((Object)"fun with \u00fctf\u0000", (Object)partialRow.getObject("string"));
        Assert.assertTrue((boolean)(partialRow.getObject("varchar") instanceof String));
        Assert.assertEquals((Object)"\u00e1rv\u00edzt\u0171r\u0151 ", (Object)partialRow.getObject("varchar"));
        Assert.assertTrue((boolean)(partialRow.getObject("binary-array") instanceof byte[]));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4}, (byte[])partialRow.getBinaryCopy("binary-array"));
        Assert.assertTrue((boolean)(partialRow.getObject("binary-bytebuffer") instanceof byte[]));
        Assert.assertEquals((Object)ByteBuffer.wrap(new byte[]{5, 6, 7, 8, 9}), (Object)partialRow.getBinary("binary-bytebuffer"));
        Assert.assertNull((Object)partialRow.getObject("null"));
        Assert.assertTrue((boolean)(partialRow.getObject("decimal") instanceof BigDecimal));
        Assert.assertEquals((Object)BigDecimal.valueOf(12345L, 3), (Object)partialRow.getObject("decimal"));
    }

    @Test
    public void testAddObject() {
        Schema schema = ClientTestUtil.getSchemaWithAllTypes();
        Assert.assertEquals((long)15L, (long)schema.getColumnCount());
        PartialRow row = schema.newPartialRow();
        row.addObject("int8", (Object)42);
        row.addObject("int16", (Object)43);
        row.addObject("int32", (Object)44);
        row.addObject("int64", (Object)45L);
        row.addObject("timestamp", (Object)new Timestamp(1234567890L));
        row.addObject("date", (Object)Date.valueOf(LocalDate.ofEpochDay(0L)));
        row.addObject("bool", (Object)true);
        row.addObject("float", (Object)Float.valueOf(52.35f));
        row.addObject("double", (Object)53.35);
        row.addObject("string", (Object)"fun with \u00fctf\u0000");
        row.addObject("varchar", (Object)"\u00e1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p");
        row.addObject("binary-array", (Object)new byte[]{0, 1, 2, 3, 4});
        ByteBuffer binaryBuffer = ByteBuffer.wrap(new byte[]{5, 6, 7, 8, 9});
        row.addObject("binary-bytebuffer", (Object)binaryBuffer);
        row.addObject("null", null);
        row.addObject("decimal", (Object)BigDecimal.valueOf(12345L, 3));
        PartialRow expected = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema col : schema.getColumns()) {
            Assert.assertEquals((Object)this.callGetByName(expected, col.getName(), col.getType()), (Object)this.callGetByName(row, col.getName(), col.getType()));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNullColumn() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        Assert.assertTrue((boolean)partialRow.isSet("null"));
        Assert.assertTrue((boolean)partialRow.isNull("null"));
        partialRow.getString("null");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNonNullableColumn() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.setNull("int32");
    }

    @Test
    public void testGetUnsetColumn() {
        Schema schema = ClientTestUtil.getSchemaWithAllTypes();
        PartialRow partialRow = schema.newPartialRow();
        for (ColumnSchema columnSchema : schema.getColumns()) {
            Assert.assertFalse((boolean)partialRow.isSet("null"));
            Assert.assertFalse((boolean)partialRow.isNull("null"));
            try {
                this.callGetByName(partialRow, columnSchema.getName(), columnSchema.getType());
                Assert.fail((String)("Expected IllegalArgumentException for type: " + columnSchema.getType()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testGetMissingColumnName() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callGetByName(partialRow, "not-a-column", columnSchema.getType());
                Assert.fail((String)("Expected IllegalArgumentException for type: " + columnSchema.getType()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testGetMissingColumnIndex() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callGetByIndex(partialRow, 999, columnSchema.getType());
                Assert.fail((String)("Expected IndexOutOfBoundsException for type: " + columnSchema.getType()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    @Test
    public void testGetWrongTypeColumn() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                if ("null".equals(columnSchema.getName())) continue;
                this.callGetByName(partialRow, columnSchema.getName(), this.getShiftedType(columnSchema.getType()));
                Assert.fail((String)("Expected IllegalArgumentException for type: " + columnSchema.getType()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testAddMissingColumnName() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callAddByName(partialRow, "not-a-column", columnSchema.getType());
                Assert.fail((String)("Expected IllegalArgumentException for type: " + columnSchema.getType()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testAddMissingColumnIndex() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callAddByIndex(partialRow, 999, columnSchema.getType());
                Assert.fail((String)("Expected IndexOutOfBoundsException for type: " + columnSchema.getType()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    @Test
    public void testAddWrongTypeColumn() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callAddByName(partialRow, columnSchema.getName(), this.getShiftedType(columnSchema.getType()));
                Assert.fail((String)("Expected IllegalArgumentException for type: " + columnSchema.getType()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testAddToFrozenRow() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.freeze();
        for (ColumnSchema columnSchema : partialRow.getSchema().getColumns()) {
            try {
                this.callAddByName(partialRow, columnSchema.getName(), columnSchema.getType());
                Assert.fail((String)("Expected IllegalStateException for type: " + columnSchema.getType()));
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsNullMissingColumnName() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.isNull("not-a-column");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIsNullMissingColumnIndex() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.isNull(999);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSetMissingColumnName() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.isSet("not-a-column");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIsSetMissingColumnIndex() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.isSet(999);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInvalidPrecisionDecimal() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.addDecimal("decimal", BigDecimal.valueOf(123456L, 3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInvalidScaleDecimal() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.addDecimal("decimal", BigDecimal.valueOf(12345L, 4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInvalidCoercedScaleDecimal() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.addDecimal("decimal", BigDecimal.valueOf(12345L, 2));
    }

    @Test
    public void testAddCoercedScaleAndPrecisionDecimal() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        partialRow.addDecimal("decimal", BigDecimal.valueOf(222L, 1));
        BigDecimal decimal = partialRow.getDecimal("decimal");
        Assert.assertEquals((Object)"22.200", (Object)decimal.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddDateOutOfRange() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        Date d = Date.valueOf(LocalDate.of(10000, 1, 1));
        partialRow.addDate("date", d);
    }

    @Test
    public void testToString() {
        Schema schema = ClientTestUtil.getSchemaWithAllTypes();
        PartialRow row = schema.newPartialRow();
        Assert.assertEquals((Object)"()", (Object)row.toString());
        row.addInt("int32", 42);
        row.addByte("int8", (byte)42);
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42)", (Object)row.toString());
        row.addString("string", "fun with \u00fctf\u0000");
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42, string string=\"fun with \u00fctf\\0\")", (Object)row.toString());
        ByteBuffer binary = ByteBuffer.wrap(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        binary.position(2);
        binary.limit(5);
        row.addBinary("binary-bytebuffer", binary);
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42, string string=\"fun with \u00fctf\\0\", binary binary-bytebuffer=[2, 3, 4])", (Object)row.toString());
        row.addDouble("double", 52.35);
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42, double double=52.35, string string=\"fun with \u00fctf\\0\", binary binary-bytebuffer=[2, 3, 4])", (Object)row.toString());
        row.addDecimal("decimal", BigDecimal.valueOf(12345L, 3));
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42, double double=52.35, string string=\"fun with \u00fctf\\0\", binary binary-bytebuffer=[2, 3, 4], decimal(5, 3) decimal=12.345)", (Object)row.toString());
        row.addVarchar("varchar", "\u00e1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p");
        Assert.assertEquals((Object)"(int8 int8=42, int32 int32=42, double double=52.35, string string=\"fun with \u00fctf\\0\", binary binary-bytebuffer=[2, 3, 4], decimal(5, 3) decimal=12.345, varchar(10) varchar=\"\u00e1rv\u00edzt\u0171r\u0151 \")", (Object)row.toString());
        PartialRow row2 = schema.newPartialRow();
        Assert.assertEquals((Object)"()", (Object)row2.toString());
        row2.addDate("date", Date.valueOf(LocalDate.ofEpochDay(0L)));
        Assert.assertEquals((Object)"(date date=1970-01-01)", (Object)row2.toString());
    }

    @Test
    public void testIncrementColumn() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        int boolIndex = this.getColumnIndex(partialRow, "bool");
        partialRow.addBoolean(boolIndex, false);
        Assert.assertTrue((boolean)partialRow.incrementColumn(boolIndex));
        Assert.assertEquals((Object)true, (Object)partialRow.getBoolean(boolIndex));
        Assert.assertFalse((boolean)partialRow.incrementColumn(boolIndex));
        int int8Index = this.getColumnIndex(partialRow, "int8");
        partialRow.addByte(int8Index, (byte)126);
        Assert.assertTrue((boolean)partialRow.incrementColumn(int8Index));
        Assert.assertEquals((long)127L, (long)partialRow.getByte(int8Index));
        Assert.assertFalse((boolean)partialRow.incrementColumn(int8Index));
        int int16Index = this.getColumnIndex(partialRow, "int16");
        partialRow.addShort(int16Index, (short)32766);
        Assert.assertTrue((boolean)partialRow.incrementColumn(int16Index));
        Assert.assertEquals((long)32767L, (long)partialRow.getShort(int16Index));
        Assert.assertFalse((boolean)partialRow.incrementColumn(int16Index));
        int int32Index = this.getColumnIndex(partialRow, "int32");
        partialRow.addInt(int32Index, 0x7FFFFFFE);
        Assert.assertTrue((boolean)partialRow.incrementColumn(int32Index));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)partialRow.getInt(int32Index));
        Assert.assertFalse((boolean)partialRow.incrementColumn(int32Index));
        int int64Index = this.getColumnIndex(partialRow, "int64");
        partialRow.addLong(int64Index, 0x7FFFFFFFFFFFFFFEL);
        Assert.assertTrue((boolean)partialRow.incrementColumn(int64Index));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)partialRow.getLong(int64Index));
        Assert.assertFalse((boolean)partialRow.incrementColumn(int64Index));
        int floatIndex = this.getColumnIndex(partialRow, "float");
        partialRow.addFloat(floatIndex, Float.MAX_VALUE);
        Assert.assertTrue((boolean)partialRow.incrementColumn(floatIndex));
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)partialRow.getFloat(floatIndex), (float)0.0f);
        Assert.assertFalse((boolean)partialRow.incrementColumn(floatIndex));
        int doubleIndex = this.getColumnIndex(partialRow, "double");
        partialRow.addDouble(doubleIndex, Double.MAX_VALUE);
        Assert.assertTrue((boolean)partialRow.incrementColumn(doubleIndex));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)partialRow.getDouble(doubleIndex), (double)0.0);
        Assert.assertFalse((boolean)partialRow.incrementColumn(doubleIndex));
        int decimalIndex = this.getColumnIndex(partialRow, "decimal");
        partialRow.addDecimal(decimalIndex, new BigDecimal("99.998"));
        Assert.assertTrue((boolean)partialRow.incrementColumn(decimalIndex));
        Assert.assertEquals((Object)new BigDecimal("99.999"), (Object)partialRow.getDecimal(decimalIndex));
        Assert.assertFalse((boolean)partialRow.incrementColumn(decimalIndex));
        int stringIndex = this.getColumnIndex(partialRow, "string");
        partialRow.addString(stringIndex, "hello");
        Assert.assertTrue((boolean)partialRow.incrementColumn(stringIndex));
        Assert.assertEquals((Object)"hello\u0000", (Object)partialRow.getString(stringIndex));
        int binaryIndex = this.getColumnIndex(partialRow, "binary-array");
        partialRow.addBinary(binaryIndex, new byte[]{0, 1, 2, 3, 4});
        Assert.assertTrue((boolean)partialRow.incrementColumn(binaryIndex));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3, 4, 0}, (byte[])partialRow.getBinaryCopy(binaryIndex));
        int varcharIndex = this.getColumnIndex(partialRow, "varchar");
        partialRow.addVarchar(varcharIndex, "hello");
        Assert.assertTrue((boolean)partialRow.incrementColumn(varcharIndex));
        Assert.assertEquals((Object)"hello\u0000", (Object)partialRow.getVarchar(varcharIndex));
        int dateIndex = this.getColumnIndex(partialRow, "date");
        partialRow.addDate(dateIndex, DateUtil.epochDaysToSqlDate((int)(DateUtil.MAX_DATE_VALUE - 1)));
        Assert.assertTrue((boolean)partialRow.incrementColumn(dateIndex));
        Date maxDate = DateUtil.epochDaysToSqlDate((int)DateUtil.MAX_DATE_VALUE);
        Assert.assertEquals((Object)maxDate, (Object)partialRow.getDate(dateIndex));
        Assert.assertFalse((boolean)partialRow.incrementColumn(dateIndex));
    }

    @Test
    public void testSetMin() {
        PartialRow partialRow = ClientTestUtil.getPartialRowWithAllTypes();
        for (int i = 0; i < partialRow.getSchema().getColumnCount(); ++i) {
            partialRow.setMin(i);
        }
        Assert.assertEquals((Object)false, (Object)partialRow.getBoolean("bool"));
        Assert.assertEquals((long)-128L, (long)partialRow.getByte("int8"));
        Assert.assertEquals((long)-32768L, (long)partialRow.getShort("int16"));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)partialRow.getInt("int32"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)partialRow.getLong("int64"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)partialRow.getLong("timestamp"));
        Assert.assertEquals((Object)DateUtil.epochDaysToSqlDate((int)DateUtil.MIN_DATE_VALUE), (Object)partialRow.getDate("date"));
        Assert.assertEquals((float)-3.4028235E38f, (float)partialRow.getFloat("float"), (float)0.0f);
        Assert.assertEquals((double)-1.7976931348623157E308, (double)partialRow.getDouble("double"), (double)0.0);
        Assert.assertEquals((Object)"", (Object)partialRow.getString("string"));
        Assert.assertEquals((Object)"", (Object)partialRow.getVarchar("varchar"));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])partialRow.getBinaryCopy("binary-array"));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])partialRow.getBinaryCopy("binary-bytebuffer"));
        Assert.assertEquals((Object)BigDecimal.valueOf(-99999L, 3), (Object)partialRow.getDecimal("decimal"));
    }

    private int getColumnIndex(PartialRow partialRow, String columnName) {
        return partialRow.getSchema().getColumnIndex(columnName);
    }

    private Type getShiftedType(Type type) {
        int shiftedPosition = (type.ordinal() + 1) % Type.values().length;
        return Type.values()[shiftedPosition];
    }

    private Object callGetByName(PartialRow partialRow, String columnName, Type type) {
        if (partialRow.isNull(columnName)) {
            return null;
        }
        switch (type) {
            case INT8: {
                return partialRow.getByte(columnName);
            }
            case INT16: {
                return partialRow.getShort(columnName);
            }
            case INT32: {
                return partialRow.getInt(columnName);
            }
            case INT64: {
                return partialRow.getLong(columnName);
            }
            case DATE: {
                return partialRow.getDate(columnName);
            }
            case UNIXTIME_MICROS: {
                return partialRow.getTimestamp(columnName);
            }
            case VARCHAR: {
                return partialRow.getVarchar(columnName);
            }
            case STRING: {
                return partialRow.getString(columnName);
            }
            case BINARY: {
                return partialRow.getBinary(columnName);
            }
            case FLOAT: {
                return Float.valueOf(partialRow.getFloat(columnName));
            }
            case DOUBLE: {
                return partialRow.getDouble(columnName);
            }
            case BOOL: {
                return partialRow.getBoolean(columnName);
            }
            case DECIMAL: {
                return partialRow.getDecimal(columnName);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object callGetByIndex(PartialRow partialRow, int columnIndex, Type type) {
        if (partialRow.isNull(columnIndex)) {
            return null;
        }
        switch (type) {
            case INT8: {
                return partialRow.getByte(columnIndex);
            }
            case INT16: {
                return partialRow.getShort(columnIndex);
            }
            case INT32: {
                return partialRow.getInt(columnIndex);
            }
            case INT64: {
                return partialRow.getLong(columnIndex);
            }
            case DATE: {
                return partialRow.getDate(columnIndex);
            }
            case UNIXTIME_MICROS: {
                return partialRow.getTimestamp(columnIndex);
            }
            case VARCHAR: {
                return partialRow.getVarchar(columnIndex);
            }
            case STRING: {
                return partialRow.getString(columnIndex);
            }
            case BINARY: {
                return partialRow.getBinary(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(partialRow.getFloat(columnIndex));
            }
            case DOUBLE: {
                return partialRow.getDouble(columnIndex);
            }
            case BOOL: {
                return partialRow.getBoolean(columnIndex);
            }
            case DECIMAL: {
                return partialRow.getDecimal(columnIndex);
            }
        }
        throw new UnsupportedOperationException();
    }

    private void callAddByName(PartialRow partialRow, String columnName, Type type) {
        switch (type) {
            case INT8: {
                partialRow.addByte(columnName, (byte)42);
                break;
            }
            case INT16: {
                partialRow.addShort(columnName, (short)43);
                break;
            }
            case INT32: {
                partialRow.addInt(columnName, 44);
                break;
            }
            case INT64: {
                partialRow.addLong(columnName, 45L);
                break;
            }
            case UNIXTIME_MICROS: {
                partialRow.addTimestamp(columnName, new Timestamp(1234567890L));
                break;
            }
            case VARCHAR: {
                partialRow.addVarchar(columnName, "fun with \u00fctf\u0000");
                break;
            }
            case STRING: {
                partialRow.addString(columnName, "fun with \u00fctf\u0000");
                break;
            }
            case BINARY: {
                partialRow.addBinary(columnName, new byte[]{0, 1, 2, 3, 4});
                break;
            }
            case FLOAT: {
                partialRow.addFloat(columnName, 52.35f);
                break;
            }
            case DOUBLE: {
                partialRow.addDouble(columnName, 53.35);
                break;
            }
            case BOOL: {
                partialRow.addBoolean(columnName, true);
                break;
            }
            case DECIMAL: {
                partialRow.addDecimal(columnName, BigDecimal.valueOf(12345L, 3));
                break;
            }
            case DATE: {
                partialRow.addDate(columnName, DateUtil.epochDaysToSqlDate((int)0));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void callAddByIndex(PartialRow partialRow, int columnIndex, Type type) {
        switch (type) {
            case INT8: {
                partialRow.addByte(columnIndex, (byte)42);
                break;
            }
            case INT16: {
                partialRow.addShort(columnIndex, (short)43);
                break;
            }
            case INT32: {
                partialRow.addInt(columnIndex, 44);
                break;
            }
            case INT64: {
                partialRow.addLong(columnIndex, 45L);
                break;
            }
            case UNIXTIME_MICROS: {
                partialRow.addTimestamp(columnIndex, new Timestamp(1234567890L));
                break;
            }
            case VARCHAR: {
                partialRow.addVarchar(columnIndex, "fun with \u00fctf\u0000");
                break;
            }
            case STRING: {
                partialRow.addString(columnIndex, "fun with \u00fctf\u0000");
                break;
            }
            case BINARY: {
                partialRow.addBinary(columnIndex, new byte[]{0, 1, 2, 3, 4});
                break;
            }
            case FLOAT: {
                partialRow.addFloat(columnIndex, 52.35f);
                break;
            }
            case DOUBLE: {
                partialRow.addDouble(columnIndex, 53.35);
                break;
            }
            case BOOL: {
                partialRow.addBoolean(columnIndex, true);
                break;
            }
            case DECIMAL: {
                partialRow.addDecimal(columnIndex, BigDecimal.valueOf(12345L, 3));
                break;
            }
            case DATE: {
                partialRow.addDate(columnIndex, DateUtil.epochDaysToSqlDate((int)0));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

