/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.DateUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOperation {
    @Rule
    public RetryRule retryRule = new RetryRule();

    private Schema createManyStringsSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(4);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c0", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c2", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c3", Type.STRING).nullable(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c4", Type.STRING).nullable(true).build());
        return new Schema(columns);
    }

    @Test
    public void testSetStrings() {
        KuduTable table = (KuduTable)Mockito.mock(KuduTable.class);
        ((KuduTable)Mockito.doReturn((Object)this.createManyStringsSchema()).when((Object)table)).getSchema();
        Insert insert = new Insert(table);
        PartialRow row = insert.getRow();
        row.addString("c0", "c0_val");
        row.addString("c2", "c2_val");
        row.addString("c1", "c1_val");
        row.addString("c3", "c3_val");
        row.addString("c4", "c4_val");
        Tserver.WriteRequestPB.Builder pb = Operation.createAndFillWriteRequestPB((List)ImmutableList.of((Object)insert));
        WireProtocol.RowOperationsPB rowOps = pb.getRowOperations();
        Assert.assertEquals((long)30L, (long)rowOps.getIndirectData().size());
        Assert.assertEquals((Object)"c0_valc1_valc2_valc3_valc4_val", (Object)rowOps.getIndirectData().toStringUtf8());
        byte[] rows = rowOps.getRows().toByteArray();
        Assert.assertEquals((long)Operation.ChangeType.INSERT.toEncodedByte(), (long)rows[0]);
        Assert.assertEquals((long)31L, (long)rows[1]);
        Assert.assertEquals((long)0L, (long)rows[2]);
        int offset = 3;
        for (long i = 0L; i <= 4L; ++i) {
            Assert.assertEquals((long)(6L * i), (long)Bytes.getLong((byte[])rows, (int)offset));
            Assert.assertEquals((long)6L, (long)Bytes.getLong((byte[])rows, (int)(offset += 8)));
            offset += 8;
        }
        Assert.assertEquals((long)rows.length, (long)offset);
        row.setNull("c3");
        pb = Operation.createAndFillWriteRequestPB((List)ImmutableList.of((Object)insert));
        rowOps = pb.getRowOperations();
        Assert.assertEquals((long)24L, (long)rowOps.getIndirectData().size());
        Assert.assertEquals((Object)"c0_valc1_valc2_valc4_val", (Object)rowOps.getIndirectData().toStringUtf8());
        rows = rowOps.getRows().toByteArray();
        Assert.assertEquals((long)Operation.ChangeType.INSERT.toEncodedByte(), (long)rows[0]);
        Assert.assertEquals((long)31L, (long)rows[1]);
        Assert.assertEquals((long)8L, (long)rows[2]);
        offset = 3;
        int indirOffset = 0;
        for (int i = 0; i <= 4; ++i) {
            if (i == 3) continue;
            Assert.assertEquals((long)indirOffset, (long)Bytes.getLong((byte[])rows, (int)offset));
            indirOffset += 6;
            Assert.assertEquals((long)6L, (long)Bytes.getLong((byte[])rows, (int)(offset += 8)));
            offset += 8;
        }
        Assert.assertEquals((long)rows.length, (long)offset);
    }

    private Schema createAllTypesKeySchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(7);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c0", Type.INT8).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.INT16).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c2", Type.INT32).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c3", Type.INT64).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c4", Type.UNIXTIME_MICROS).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c5", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c6", Type.BINARY).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c7", Type.DATE).key(true).build());
        return new Schema(columns);
    }

    @Test
    public void testRowKeyStringify() {
        KuduTable table = (KuduTable)Mockito.mock(KuduTable.class);
        ((KuduTable)Mockito.doReturn((Object)this.createAllTypesKeySchema()).when((Object)table)).getSchema();
        Insert insert = new Insert(table);
        PartialRow row = insert.getRow();
        row.addByte("c0", (byte)1);
        row.addShort("c1", (short)2);
        row.addInt("c2", 3);
        row.addLong("c3", 4L);
        row.addLong("c4", 5L);
        row.addString("c5", "c5_val");
        row.addBinary("c6", Bytes.fromString((String)"c6_val"));
        row.addDate("c7", DateUtil.epochDaysToSqlDate((int)0));
        Assert.assertEquals((Object)"(int8 c0=1, int16 c1=2, int32 c2=3, int64 c3=4, unixtime_micros c4=1970-01-01T00:00:00.000005Z, string c5=\"c5_val\", binary c6=\"c6_val\", date c7=1970-01-01)", (Object)insert.getRow().stringifyRowKey());
        insert = new Insert(table);
        row = insert.getRow();
        row.addByte("c0", (byte)1);
        try {
            row.stringifyRowKey();
            Assert.fail((String)"Should not be able to stringifyRowKey when not all keys are specified");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

