/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.Closeable;
import junit.framework.TestCase;
import org.apache.kudu.test.CapturingLogAppender;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.FakeDNS;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Rule;
import org.junit.Test;

public class TestNegotiation {
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = new MiniKuduCluster.MiniKuduClusterBuilder().numMasterServers(1).numTabletServers(0).enableKerberos();
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Test
    @KuduTestHarness.MasterServerConfig(flags={"--rpc-authentication=optional", "--rpc-trace-negotiation", "--user-acl=*"})
    public void testSaslPlainFallback() throws Exception {
        FakeDNS.getInstance().install();
        CapturingLogAppender cla = new CapturingLogAppender();
        this.harness.kdestroy();
        this.harness.resetClients();
        try (Closeable c = cla.attach();){
            TestCase.assertTrue((boolean)this.harness.getClient().getTablesList().getTablesList().isEmpty());
        }
        TestCase.assertTrue((String)cla.getAppendedText(), (boolean)cla.getAppendedText().contains("Client requested to use mechanism: PLAIN"));
    }
}

