/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestMultiMasterAuthzTokens {
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().addMasterServerFlag("--authz_token_validity_seconds=1").addTabletServerFlag("--tserver_enforce_access_control=true").addTabletServerFlag("--tserver_inject_invalid_authz_token_ratio=0.5");
    private static final String tableName = "TestMultiMasterAuthzToken-table";
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
    }

    private void insertRows(KuduTable table, SessionConfiguration.FlushMode mode, int startRow, int endRow) throws Exception {
        KuduSession session = this.client.newSession();
        session.setFlushMode(mode);
        for (int i = startRow; i < endRow; ++i) {
            Insert insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i);
            session.apply((Operation)insert);
        }
        session.flush();
    }

    private void upsertRows(KuduTable table, SessionConfiguration.FlushMode mode, int startRow, int endRow) throws Exception {
        KuduSession session = this.client.newSession();
        session.setFlushMode(mode);
        for (int i = startRow; i < endRow; ++i) {
            Upsert upsert = ClientTestUtil.createBasicSchemaUpsert((KuduTable)table, (int)i);
            session.apply((Operation)upsert);
        }
        session.flush();
    }

    @Test
    public void testAuthzTokensDuringElection() throws Exception {
        KuduTable table = this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions().setNumReplicas(1));
        this.harness.killAllMasterServers();
        this.harness.startAllMasterServers();
        int NUM_REQS = 10;
        this.insertRows(table, SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC, 0, 10);
        this.harness.killAllMasterServers();
        this.harness.startAllMasterServers();
        this.insertRows(table, SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND, 10, 20);
        this.harness.killAllMasterServers();
        this.harness.startAllMasterServers();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)20L, (long)ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]));
        }
    }

    @Test
    public void testAuthzTokenExpiration() throws Exception {
        int TEST_RUNTIME_MS = 30000;
        final KuduTable table = this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions().setNumReplicas(1));
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService pool = Executors.newFixedThreadPool(3);
        ArrayList<Future<Exception>> exceptions = new ArrayList<Future<Exception>>();
        exceptions.add(pool.submit(new Callable<Exception>(){

            @Override
            public Exception call() throws Exception {
                try {
                    int batch = 0;
                    while (latch.getCount() > 0L) {
                        TestMultiMasterAuthzTokens.this.upsertRows(table, SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC, batch * 10, ++batch * 10);
                    }
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        }));
        exceptions.add(pool.submit(new Callable<Exception>(){

            @Override
            public Exception call() throws Exception {
                try {
                    int batch = 0;
                    while (latch.getCount() > 0L) {
                        TestMultiMasterAuthzTokens.this.upsertRows(table, SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND, batch * 10, ++batch * 10);
                    }
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        }));
        exceptions.add(pool.submit(new Callable<Exception>(){

            @Override
            public Exception call() throws Exception {
                try {
                    while (latch.getCount() > 0L) {
                        ClientTestUtil.countRowsInTable((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
                    }
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        }));
        Thread.sleep(30000L);
        latch.countDown();
        int fails = 0;
        for (Future future : exceptions) {
            Exception e = (Exception)future.get();
            if (e == null) continue;
            e.printStackTrace();
            ++fails;
        }
        Assert.assertEquals((long)0L, (long)fails);
    }
}

