/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.KuduTableStatistics;
import org.apache.kudu.client.ListTablesResponse;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKuduTable {
    private static final Logger LOG = LoggerFactory.getLogger(TestKuduTable.class);
    private static final Schema BASIC_SCHEMA = ClientTestUtil.getBasicSchema();
    private static final String tableName = "TestKuduTable";
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    @Test(timeout=100000L)
    public void testAlterColumn() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).key(true).build(), (Object)new ColumnSchema.ColumnSchemaBuilder("value", Type.STRING).nullable(true).desiredBlockSize(4096).encoding(ColumnSchema.Encoding.PLAIN_ENCODING).compressionAlgorithm(ColumnSchema.CompressionAlgorithm.NO_COMPRESSION).build());
        KuduTable table = this.client.createTable(tableName, new Schema((List)columns), ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        this.insertDefaultRow(table, session, 0);
        List rows = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((String)"wrong number of rows", (long)1L, (long)rows.size());
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=0, STRING value=NULL", rows.get(0));
        this.client.alterTable(tableName, new AlterTableOptions().changeDefault("value", (Object)"pizza"));
        this.insertDefaultRow(table, session, 1);
        rows = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((String)"wrong number of rows", (long)2L, (long)rows.size());
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=0, STRING value=NULL", rows.get(0));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=1, STRING value=pizza", rows.get(1));
        this.client.alterTable(tableName, new AlterTableOptions().changeDefault("value", (Object)"taco"));
        this.insertDefaultRow(table, session, 2);
        rows = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((String)"wrong number of rows", (long)3L, (long)rows.size());
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=0, STRING value=NULL", rows.get(0));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=1, STRING value=pizza", rows.get(1));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=2, STRING value=taco", rows.get(2));
        this.client.alterTable(tableName, new AlterTableOptions().removeDefault("value"));
        this.insertDefaultRow(table, session, 3);
        rows = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((String)"wrong number of rows", (long)4L, (long)rows.size());
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=0, STRING value=NULL", rows.get(0));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=1, STRING value=pizza", rows.get(1));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=2, STRING value=taco", rows.get(2));
        Assert.assertEquals((String)"wrong row", (Object)"INT32 key=3, STRING value=NULL", rows.get(3));
        Assert.assertEquals((String)"wrong block size", (long)4096L, (long)table.getSchema().getColumn("value").getDesiredBlockSize());
        Assert.assertEquals((String)"wrong encoding", (Object)ColumnSchema.Encoding.PLAIN_ENCODING, (Object)table.getSchema().getColumn("value").getEncoding());
        Assert.assertEquals((String)"wrong compression algorithm", (Object)ColumnSchema.CompressionAlgorithm.NO_COMPRESSION, (Object)table.getSchema().getColumn("value").getCompressionAlgorithm());
        this.client.alterTable(tableName, new AlterTableOptions().changeDesiredBlockSize("value", 8192).changeEncoding("value", ColumnSchema.Encoding.DICT_ENCODING).changeCompressionAlgorithm("value", ColumnSchema.CompressionAlgorithm.SNAPPY));
        KuduTable reopenedTable = this.client.openTable(tableName);
        Assert.assertEquals((String)"wrong block size post alter", (long)8192L, (long)reopenedTable.getSchema().getColumn("value").getDesiredBlockSize());
        Assert.assertEquals((String)"wrong encoding post alter", (Object)ColumnSchema.Encoding.DICT_ENCODING, (Object)reopenedTable.getSchema().getColumn("value").getEncoding());
        Assert.assertEquals((String)"wrong compression algorithm post alter", (Object)ColumnSchema.CompressionAlgorithm.SNAPPY, (Object)reopenedTable.getSchema().getColumn("value").getCompressionAlgorithm());
    }

    private void insertDefaultRow(KuduTable table, KuduSession session, int key) throws Exception {
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        row.addInt("key", key);
        session.apply((Operation)insert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testAlterTable() throws Exception {
        this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        try {
            this.client.alterTable(tableName, new AlterTableOptions().addColumn("testaddint", Type.INT32, (Object)4));
            this.client.alterTable(tableName, new AlterTableOptions().renameColumn("testaddint", "newtestaddint"));
            this.client.alterTable(tableName, new AlterTableOptions().dropColumn("newtestaddint"));
            String newTableName = "TestKuduTablenew";
            this.client.alterTable(tableName, new AlterTableOptions().renameTable(newTableName));
            this.client.alterTable(newTableName, new AlterTableOptions().renameTable(tableName));
            this.client.alterTable(tableName, new AlterTableOptions().addColumn("testaddmulticolnotnull", Type.INT32, (Object)4).addNullableColumn("testaddmulticolnull", Type.STRING).addColumn("testaddmulticolTimestampcol", Type.UNIXTIME_MICROS, (Object)(System.currentTimeMillis() * 1000L)));
            String nonExistingTableName = "table_does_not_exist";
            try {
                this.client.alterTable(nonExistingTableName, new AlterTableOptions());
                Assert.fail((String)"Shouldn't be able to alter a table that doesn't exist");
            }
            catch (KuduException ex) {
                Assert.assertTrue((boolean)ex.getStatus().isNotFound());
            }
            try {
                this.client.isAlterTableDone(nonExistingTableName);
                Assert.fail((String)"Shouldn't be able to query if an alter table is done here");
            }
            catch (KuduException ex) {
                Assert.assertTrue((boolean)ex.getStatus().isNotFound());
            }
        }
        finally {
            this.client.deleteTable(tableName);
        }
    }

    @Test
    public void testGetLocations() throws Exception {
        int initialTableCount = ((ListTablesResponse)this.asyncClient.getTablesList().join(50000L)).getTablesList().size();
        String NON_EXISTENT_TABLE = "NON_EXISTENT_TABLE";
        try {
            this.client.openTable("NON_EXISTENT_TABLE");
            Assert.fail((String)"Should receive an exception since the table doesn't exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String tableWithDefault = "TestKuduTable-WithDefault";
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(BASIC_SCHEMA.getColumnCount());
        int defaultInt = 30;
        String defaultString = "data";
        for (ColumnSchema columnSchema : BASIC_SCHEMA.getColumns()) {
            Object defaultValue = columnSchema.getType() == Type.INT32 ? Integer.valueOf(defaultInt) : (columnSchema.getType() == Type.BOOL ? Boolean.valueOf(true) : defaultString);
            columns.add(new ColumnSchema.ColumnSchemaBuilder(columnSchema.getName(), columnSchema.getType()).key(columnSchema.isKey()).nullable(columnSchema.isNullable()).defaultValue(defaultValue).build());
        }
        Schema schemaWithDefault = new Schema(columns);
        KuduTable kuduTable = this.client.createTable(tableWithDefault, schemaWithDefault, builder);
        Assert.assertEquals((Object)defaultInt, (Object)kuduTable.getSchema().getColumnByIndex(0).getDefaultValue());
        Assert.assertEquals((Object)defaultString, (Object)kuduTable.getSchema().getColumnByIndex(columns.size() - 2).getDefaultValue());
        Assert.assertEquals((Object)true, (Object)kuduTable.getSchema().getColumnByIndex(columns.size() - 1).getDefaultValue());
        Assert.assertTrue((boolean)kuduTable.getSchema().hasColumnIds());
        this.client.openTable(tableWithDefault);
        String splitTablePrefix = "TestKuduTable-Splits";
        KuduTable kuduTableWithoutDefaults = this.createTableWithSplitsAndTest(splitTablePrefix, 0);
        Assert.assertNull((Object)kuduTableWithoutDefaults.getSchema().getColumnByIndex(0).getDefaultValue());
        this.createTableWithSplitsAndTest(splitTablePrefix, 3);
        this.createTableWithSplitsAndTest(splitTablePrefix, 10);
        KuduTable table = this.createTableWithSplitsAndTest(splitTablePrefix, 30);
        List tablets = table.getTabletsLocations(null, this.getKeyInBytes(9), 50000L);
        Assert.assertEquals((long)9L, (long)tablets.size());
        Assert.assertEquals((long)9L, (long)((List)table.asyncGetTabletsLocations(null, this.getKeyInBytes(9), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(0), this.getKeyInBytes(9), 50000L);
        Assert.assertEquals((long)9L, (long)tablets.size());
        Assert.assertEquals((long)9L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(0), this.getKeyInBytes(9), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(9), 50000L);
        Assert.assertEquals((long)4L, (long)tablets.size());
        Assert.assertEquals((long)4L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(9), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(14), 50000L);
        Assert.assertEquals((long)9L, (long)tablets.size());
        Assert.assertEquals((long)9L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(14), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(31), 50000L);
        Assert.assertEquals((long)26L, (long)tablets.size());
        Assert.assertEquals((long)26L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(5), this.getKeyInBytes(31), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(5), null, 50000L);
        Assert.assertEquals((long)26L, (long)tablets.size());
        Assert.assertEquals((long)26L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(5), null, 50000L).join()).size());
        tablets = table.getTabletsLocations(null, this.getKeyInBytes(10000), 50000L);
        Assert.assertEquals((long)31L, (long)tablets.size());
        Assert.assertEquals((long)31L, (long)((List)table.asyncGetTabletsLocations(null, this.getKeyInBytes(10000), 50000L).join()).size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(20), this.getKeyInBytes(10000), 50000L);
        Assert.assertEquals((long)11L, (long)tablets.size());
        Assert.assertEquals((long)11L, (long)((List)table.asyncGetTabletsLocations(this.getKeyInBytes(20), this.getKeyInBytes(10000), 50000L).join()).size());
        Assert.assertEquals((long)0L, (long)((ListTablesResponse)this.asyncClient.getTablesList("NON_EXISTENT_TABLE").join(50000L)).getTablesList().size());
        Assert.assertEquals((long)1L, (long)((ListTablesResponse)this.asyncClient.getTablesList(tableWithDefault).join(50000L)).getTablesList().size());
        Assert.assertEquals((long)(initialTableCount + 5), (long)((ListTablesResponse)this.asyncClient.getTablesList().join(50000L)).getTablesList().size());
        Assert.assertFalse((boolean)((ListTablesResponse)this.asyncClient.getTablesList(tableWithDefault).join(50000L)).getTablesList().isEmpty());
        Assert.assertFalse((boolean)((Boolean)this.asyncClient.tableExists("NON_EXISTENT_TABLE").join(50000L)));
        Assert.assertTrue((boolean)((Boolean)this.asyncClient.tableExists(tableWithDefault).join(50000L)));
    }

    @Test(timeout=100000L)
    public void testLocateTableNonCoveringRange() throws Exception {
        this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicTableOptionsWithNonCoveredRange());
        KuduTable table = this.client.openTable(tableName);
        List tablets = table.getTabletsLocations(null, null, 100000L);
        Assert.assertEquals((long)3L, (long)tablets.size());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(0), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(50), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyEnd());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(50), (byte[])((LocatedTablet)tablets.get(1)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(100), (byte[])((LocatedTablet)tablets.get(1)).getPartition().getPartitionKeyEnd());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(200), (byte[])((LocatedTablet)tablets.get(2)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(300), (byte[])((LocatedTablet)tablets.get(2)).getPartition().getPartitionKeyEnd());
        tablets = table.getTabletsLocations(null, this.getKeyInBytes(50), 100000L);
        Assert.assertEquals((long)1L, (long)tablets.size());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(0), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(50), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyEnd());
        tablets = table.getTabletsLocations(this.getKeyInBytes(300), null, 100000L);
        Assert.assertEquals((long)0L, (long)tablets.size());
        tablets = table.getTabletsLocations(this.getKeyInBytes(299), null, 100000L);
        Assert.assertEquals((long)1L, (long)tablets.size());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(200), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(300), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyEnd());
        tablets = table.getTabletsLocations(this.getKeyInBytes(150), this.getKeyInBytes(250), 100000L);
        Assert.assertEquals((long)1L, (long)tablets.size());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(200), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(300), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyEnd());
    }

    public byte[] getKeyInBytes(int i) {
        PartialRow row = BASIC_SCHEMA.newPartialRow();
        row.addInt(0, i);
        return row.encodePrimaryKey();
    }

    @Test(timeout=100000L)
    public void testAlterTableNonCoveringRange() throws Exception {
        this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicTableOptionsWithNonCoveredRange());
        KuduTable table = this.client.openTable(tableName);
        KuduSession session = this.client.newSession();
        AlterTableOptions ato = new AlterTableOptions();
        PartialRow lowerBound = BASIC_SCHEMA.newPartialRow();
        lowerBound.addInt("key", 300);
        PartialRow upperBound = BASIC_SCHEMA.newPartialRow();
        upperBound.addInt("key", 400);
        ato.addRangePartition(lowerBound, upperBound);
        this.client.alterTable(tableName, ato);
        Insert insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)301);
        session.apply((Operation)insert);
        List tablets = table.getTabletsLocations(this.getKeyInBytes(300), null, 100000L);
        Assert.assertEquals((long)1L, (long)tablets.size());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(300), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyStart());
        Assert.assertArrayEquals((byte[])this.getKeyInBytes(400), (byte[])((LocatedTablet)tablets.get(0)).getPartition().getPartitionKeyEnd());
        insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)201);
        session.apply((Operation)insert);
        ato = new AlterTableOptions();
        lowerBound = BASIC_SCHEMA.newPartialRow();
        lowerBound.addInt("key", 200);
        upperBound = BASIC_SCHEMA.newPartialRow();
        upperBound.addInt("key", 300);
        ato.dropRangePartition(lowerBound, upperBound);
        this.client.alterTable(tableName, ato);
        insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)202);
        OperationResponse response = session.apply((Operation)insert);
        Assert.assertTrue((boolean)response.hasRowError());
        Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isNotFound());
    }

    @Test(timeout=100000L)
    public void testFormatRangePartitions() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        ArrayList expected = Lists.newArrayList();
        expected.add("VALUES < -300");
        PartialRow upper = basicSchema.newPartialRow();
        upper.addInt(0, -300);
        builder.addRangePartition(basicSchema.newPartialRow(), upper);
        expected.add("-100 <= VALUES < 0");
        PartialRow lower = basicSchema.newPartialRow();
        lower.addInt(0, -100);
        PartialRow upper2 = basicSchema.newPartialRow();
        upper2.addInt(0, 0);
        builder.addRangePartition(lower, upper2);
        expected.add("0 <= VALUES < 100");
        lower = basicSchema.newPartialRow();
        lower.addInt(0, -1);
        upper2 = basicSchema.newPartialRow();
        upper2.addInt(0, 99);
        builder.addRangePartition(lower, upper2, RangePartitionBound.EXCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND);
        expected.add("VALUE = 300");
        lower = basicSchema.newPartialRow();
        lower.addInt(0, 300);
        upper2 = basicSchema.newPartialRow();
        upper2.addInt(0, 300);
        builder.addRangePartition(lower, upper2, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND);
        expected.add("VALUES >= 400");
        lower = basicSchema.newPartialRow();
        lower.addInt(0, 400);
        builder.addRangePartition(lower, basicSchema.newPartialRow());
        this.client.createTable(tableName, basicSchema, builder);
        Assert.assertEquals((Object)expected, (Object)this.client.openTable(tableName).getFormattedRangePartitions(10000L));
    }

    @Test(timeout=100000L)
    public void testFormatRangePartitionsCompoundColumns() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build());
        Schema schema = new Schema(columns);
        CreateTableOptions builder = new CreateTableOptions();
        builder.addHashPartitions((List)ImmutableList.of((Object)"a"), 2);
        builder.addHashPartitions((List)ImmutableList.of((Object)"b"), 2);
        builder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b"));
        ArrayList expected = Lists.newArrayList();
        expected.add("VALUES < (\"\", -100)");
        PartialRow upper = schema.newPartialRow();
        upper.addString(0, "");
        upper.addByte(1, (byte)-100);
        builder.addRangePartition(schema.newPartialRow(), upper);
        expected.add("VALUE = (\"abc\", 0)");
        PartialRow lower = schema.newPartialRow();
        lower.addString(0, "abc");
        lower.addByte(1, (byte)0);
        PartialRow upper2 = schema.newPartialRow();
        upper2.addString(0, "abc");
        upper2.addByte(1, (byte)1);
        builder.addRangePartition(lower, upper2);
        expected.add("(\"def\", 0) <= VALUES < (\"ghi\", 100)");
        lower = schema.newPartialRow();
        lower.addString(0, "def");
        lower.addByte(1, (byte)-1);
        upper2 = schema.newPartialRow();
        upper2.addString(0, "ghi");
        upper2.addByte(1, (byte)99);
        builder.addRangePartition(lower, upper2, RangePartitionBound.EXCLUSIVE_BOUND, RangePartitionBound.INCLUSIVE_BOUND);
        this.client.createTable(tableName, schema, builder);
        Assert.assertEquals((Object)expected, (Object)this.client.openTable(tableName).getFormattedRangePartitions(10000L));
    }

    @Test(timeout=100000L)
    public void testFormatRangePartitionsStringColumn() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.STRING).key(true).build());
        Schema schema = new Schema(columns);
        CreateTableOptions builder = new CreateTableOptions();
        builder.setRangePartitionColumns((List)ImmutableList.of((Object)"a"));
        ArrayList expected = Lists.newArrayList();
        expected.add("VALUES < \"\\0\"");
        PartialRow upper = schema.newPartialRow();
        upper.addString(0, "\u0000");
        builder.addRangePartition(schema.newPartialRow(), upper);
        expected.add("VALUE = \"abc\"");
        PartialRow lower = schema.newPartialRow();
        lower.addString(0, "abc");
        PartialRow upper2 = schema.newPartialRow();
        upper2.addString(0, "abc\u0000");
        builder.addRangePartition(lower, upper2);
        expected.add("\"def\" <= VALUES < \"ghi\"");
        lower = schema.newPartialRow();
        lower.addString(0, "def");
        upper2 = schema.newPartialRow();
        upper2.addString(0, "ghi");
        builder.addRangePartition(lower, upper2);
        expected.add("VALUES >= \"z\"");
        lower = schema.newPartialRow();
        lower.addString(0, "z");
        builder.addRangePartition(lower, schema.newPartialRow());
        this.client.createTable(tableName, schema, builder);
        Assert.assertEquals((Object)expected, (Object)this.client.openTable(tableName).getFormattedRangePartitions(10000L));
    }

    @Test(timeout=100000L)
    public void testFormatRangePartitionsUnbounded() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        this.client.createTable(tableName, basicSchema, builder);
        Assert.assertEquals((Object)ImmutableList.of((Object)"UNBOUNDED"), (Object)this.client.openTable(tableName).getFormattedRangePartitions(10000L));
    }

    private KuduTable createTableWithSplitsAndTest(String tableNamePrefix, int splitsCount) throws Exception {
        String newTableName = tableNamePrefix + "-" + splitsCount;
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        if (splitsCount != 0) {
            for (int i = 1; i <= splitsCount; ++i) {
                PartialRow row = BASIC_SCHEMA.newPartialRow();
                row.addInt(0, i);
                builder.addSplitRow(row);
            }
        }
        KuduTable table = this.client.createTable(newTableName, BASIC_SCHEMA, builder);
        List tablets = table.getTabletsLocations(50000L);
        Assert.assertEquals((long)(splitsCount + 1), (long)tablets.size());
        Assert.assertEquals((long)(splitsCount + 1), (long)((List)table.asyncGetTabletsLocations(50000L).join()).size());
        for (LocatedTablet tablet : tablets) {
            Assert.assertEquals((long)3L, (long)tablet.getReplicas().size());
        }
        return table;
    }

    @Test(timeout=100000L)
    public void testGetRangePartitions() throws Exception {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("a", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("b", Type.INT8).key(true).build());
        Schema schema = new Schema(columns);
        CreateTableOptions builder = new CreateTableOptions();
        builder.addHashPartitions((List)ImmutableList.of((Object)"a"), 2);
        builder.addHashPartitions((List)ImmutableList.of((Object)"b"), 2);
        builder.setRangePartitionColumns((List)ImmutableList.of((Object)"a", (Object)"b"));
        PartialRow bottom = schema.newPartialRow();
        PartialRow middle = schema.newPartialRow();
        middle.addString("a", "");
        middle.addByte("b", (byte)-100);
        PartialRow upper = schema.newPartialRow();
        builder.addRangePartition(bottom, middle);
        builder.addRangePartition(middle, upper);
        KuduTable table = this.client.createTable(tableName, schema, builder);
        List rangePartitions = table.getRangePartitions(this.client.getDefaultOperationTimeoutMs());
        Assert.assertEquals((long)rangePartitions.size(), (long)2L);
        Partition lowerPartition = (Partition)rangePartitions.get(0);
        Assert.assertEquals((long)0L, (long)lowerPartition.getRangeKeyStart().length);
        Assert.assertTrue((lowerPartition.getRangeKeyEnd().length > 0 ? 1 : 0) != 0);
        PartialRow decodedLower = lowerPartition.getDecodedRangeKeyEnd(table);
        Assert.assertEquals((Object)"", (Object)decodedLower.getString("a"));
        Assert.assertEquals((long)-100L, (long)decodedLower.getByte("b"));
        Partition upperPartition = (Partition)rangePartitions.get(1);
        Assert.assertTrue((upperPartition.getRangeKeyStart().length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)upperPartition.getRangeKeyEnd().length);
        PartialRow decodedUpper = upperPartition.getDecodedRangeKeyStart(table);
        Assert.assertEquals((Object)"", (Object)decodedUpper.getString("a"));
        Assert.assertEquals((long)-100L, (long)decodedUpper.getByte("b"));
    }

    @Test(timeout=100000L)
    public void testGetRangePartitionsUnbounded() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        KuduTable table = this.client.createTable(tableName, BASIC_SCHEMA, builder);
        List rangePartitions = table.getRangePartitions(this.client.getDefaultOperationTimeoutMs());
        Assert.assertEquals((long)rangePartitions.size(), (long)1L);
        Partition partition = (Partition)rangePartitions.get(0);
        Assert.assertEquals((long)0L, (long)partition.getRangeKeyStart().length);
        Assert.assertEquals((long)0L, (long)partition.getRangeKeyEnd().length);
    }

    @Test(timeout=100000L)
    public void testAlterNoWait() throws Exception {
        this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        String oldName = "column2_i";
        for (int i = 0; i < 10; ++i) {
            String newName = String.format("foo%d", i);
            this.client.alterTable(tableName, new AlterTableOptions().renameColumn(oldName, newName).setWait(false));
            KuduTable table = this.client.openTable(tableName);
            try {
                table.getSchema().getColumn(oldName);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Alter finished too quickly (old column name {} is already gone), trying again", (Object)oldName);
                oldName = newName;
                continue;
            }
            try {
                table.getSchema().getColumn(newName);
                Assert.fail((String)String.format("New column name %s should not yet be visible", newName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)this.client.isAlterTableDone(tableName));
            table = this.client.openTable(tableName);
            try {
                table.getSchema().getColumn(oldName);
                Assert.fail((String)String.format("Old column name %s should not be visible", oldName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            table.getSchema().getColumn(newName);
            LOG.info("Test passed on attempt {}", (Object)(i + 1));
            return;
        }
        Assert.fail((String)"Could not run test even after multiple attempts");
    }

    @Test(timeout=100000L)
    public void testNumReplicas() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            if (i % 2 == 0) continue;
            String tableName = "testNumReplicas-" + i;
            CreateTableOptions options = ClientTestUtil.getBasicCreateTableOptions();
            options.setNumReplicas(i);
            this.client.createTable(tableName, basicSchema, options);
            KuduTable table = this.client.openTable(tableName);
            Assert.assertEquals((long)i, (long)table.getNumReplicas());
        }
    }

    @Test(timeout=100000L)
    public void testAlterColumnComment() throws Exception {
        ImmutableList columns = ImmutableList.of((Object)new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).key(true).comment("keytest").build(), (Object)new ColumnSchema.ColumnSchemaBuilder("value", Type.STRING).comment("valuetest").build());
        KuduTable table = this.client.createTable(tableName, new Schema((List)columns), ClientTestUtil.getBasicCreateTableOptions());
        Assert.assertEquals((String)"wrong key comment", (Object)"keytest", (Object)table.getSchema().getColumn("key").getComment());
        Assert.assertEquals((String)"wrong value comment", (Object)"valuetest", (Object)table.getSchema().getColumn("value").getComment());
        this.client.alterTable(tableName, new AlterTableOptions().changeComment("key", "keycomment"));
        this.client.alterTable(tableName, new AlterTableOptions().changeComment("value", "valuecomment"));
        KuduTable table1 = this.client.openTable(tableName);
        Assert.assertEquals((String)"wrong key comment post alter", (Object)"keycomment", (Object)table1.getSchema().getColumn("key").getComment());
        Assert.assertEquals((String)"wrong value comment post alter", (Object)"valuecomment", (Object)table1.getSchema().getColumn("value").getComment());
        this.client.alterTable(tableName, new AlterTableOptions().changeComment("key", ""));
        this.client.alterTable(tableName, new AlterTableOptions().changeComment("value", ""));
        KuduTable table2 = this.client.openTable(tableName);
        Assert.assertEquals((String)"wrong key comment post alter", (Object)"", (Object)table2.getSchema().getColumn("key").getComment());
        Assert.assertEquals((String)"wrong value comment post alter", (Object)"", (Object)table2.getSchema().getColumn("value").getComment());
    }

    @Test(timeout=100000L)
    public void testDimensionLabel() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicTableOptionsWithNonCoveredRange().setDimensionLabel("labelA"));
        AlterTableOptions ato = new AlterTableOptions();
        PartialRow lowerBound = BASIC_SCHEMA.newPartialRow();
        lowerBound.addInt("key", 300);
        PartialRow upperBound = BASIC_SCHEMA.newPartialRow();
        upperBound.addInt("key", 400);
        ato.addRangePartition(lowerBound, upperBound, "labelB", RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
        this.client.alterTable(tableName, ato);
        HashMap<String, Integer> dimensionMap = new HashMap<String, Integer>();
        for (LocatedTablet tablet : table.getTabletsLocations(50000L)) {
            for (LocatedTablet.Replica replica : tablet.getReplicas()) {
                Integer number = (Integer)dimensionMap.get(replica.getDimensionLabel());
                if (number == null) {
                    number = 0;
                }
                dimensionMap.put(replica.getDimensionLabel(), number + 1);
            }
        }
        Assert.assertEquals((long)9L, (long)((Integer)dimensionMap.get("labelA")).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)dimensionMap.get("labelB")).intValue());
    }

    @Test(timeout=100000L)
    @KuduTestHarness.TabletServerConfig(flags={"--update_tablet_stats_interval_ms=200", "--heartbeat_interval_ms=100"})
    public void testGetTableStatistics() throws Exception {
        KuduTableStatistics currentStatistics;
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        KuduTable table = this.client.createTable(tableName, BASIC_SCHEMA, builder);
        KuduTableStatistics prevStatistics = new KuduTableStatistics(-1L, -1L);
        KuduSession session = this.client.newSession();
        int num = 100;
        for (int i = 0; i < num; ++i) {
            currentStatistics = table.getTableStatistics();
            Assert.assertTrue((currentStatistics.getOnDiskSize() >= prevStatistics.getOnDiskSize() ? 1 : 0) != 0);
            Assert.assertTrue((currentStatistics.getLiveRowCount() >= prevStatistics.getLiveRowCount() ? 1 : 0) != 0);
            Assert.assertTrue((currentStatistics.getLiveRowCount() <= (long)(i + 1) ? 1 : 0) != 0);
            prevStatistics = currentStatistics;
            Insert insert = ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)i);
            session.apply((Operation)insert);
            List rows = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
            Assert.assertEquals((String)"wrong number of rows", (long)(i + 1), (long)rows.size());
        }
        Thread.sleep(1200L);
        currentStatistics = table.getTableStatistics();
        Assert.assertTrue((currentStatistics.getOnDiskSize() >= prevStatistics.getOnDiskSize() ? 1 : 0) != 0);
        Assert.assertTrue((currentStatistics.getLiveRowCount() >= prevStatistics.getLiveRowCount() ? 1 : 0) != 0);
        Assert.assertEquals((long)num, (long)currentStatistics.getLiveRowCount());
    }
}

