/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.InsertIgnore;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Update;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestKuduSession {
    private static final String tableName = "TestKuduSession";
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    @Test(timeout=100000L)
    public void testBasicOps() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        for (int i = 0; i < 10; ++i) {
            session.apply((Operation)this.createInsert(table, i));
        }
        Assert.assertEquals((long)10L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
        OperationResponse resp = session.apply((Operation)this.createInsert(table, 0));
        Assert.assertTrue((boolean)resp.hasRowError());
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        for (int i = 10; i < 20; ++i) {
            session.apply((Operation)this.createInsert(table, i));
        }
        session.flush();
        Assert.assertEquals((long)20L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
    }

    @Test(timeout=100000L)
    public void testIgnoreAllDuplicateRows() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setIgnoreAllDuplicateRows(true);
        for (int i = 0; i < 10; ++i) {
            session.apply((Operation)this.createInsert(table, i));
        }
        for (SessionConfiguration.FlushMode mode : SessionConfiguration.FlushMode.values()) {
            session.setFlushMode(mode);
            for (int i = 0; i < 10; ++i) {
                OperationResponse resp = session.apply((Operation)this.createInsert(table, i));
                if (mode != SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) continue;
                Assert.assertFalse((boolean)resp.hasRowError());
            }
            if (mode == SessionConfiguration.FlushMode.MANUAL_FLUSH) {
                List responses = session.flush();
                for (OperationResponse resp : responses) {
                    Assert.assertFalse((boolean)resp.hasRowError());
                }
                continue;
            }
            if (mode != SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND) continue;
            while (session.hasPendingOperations()) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)0L, (long)session.countPendingErrors());
        }
    }

    @Test(timeout=100000L)
    public void testIgnoreAllNotFoundRows() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setIgnoreAllNotFoundRows(true);
        for (SessionConfiguration.FlushMode mode : SessionConfiguration.FlushMode.values()) {
            session.setFlushMode(mode);
            for (int i = 0; i < 10; ++i) {
                session.apply((Operation)this.createDelete(table, i));
                OperationResponse resp = session.apply((Operation)this.createInsert(table, i));
                if (mode != SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) continue;
                Assert.assertFalse((boolean)resp.hasRowError());
            }
            if (mode == SessionConfiguration.FlushMode.MANUAL_FLUSH) {
                List responses = session.flush();
                for (OperationResponse resp : responses) {
                    Assert.assertFalse((boolean)resp.hasRowError());
                }
                continue;
            }
            if (mode != SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND) continue;
            while (session.hasPendingOperations()) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)0L, (long)session.countPendingErrors());
        }
    }

    @Test(timeout=100000L)
    public void testBatchWithSameRow() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        for (int i = 0; i < 25; ++i) {
            session.apply((Operation)this.createInsert(table, i));
            for (int j = 0; j < 50; ++j) {
                Update update = table.newUpdate();
                PartialRow row = update.getRow();
                row.addInt(basicSchema.getColumnByIndex(0).getName(), i);
                row.addInt(basicSchema.getColumnByIndex(1).getName(), 1000);
                session.apply((Operation)update);
            }
            Delete del = table.newDelete();
            PartialRow row = del.getRow();
            row.addInt(basicSchema.getColumnByIndex(0).getName(), i);
            session.apply((Operation)del);
            session.flush();
            if (i % 2 != 0) continue;
            this.asyncClient.emptyTabletsCacheForTable(table.getTableId());
        }
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
    }

    @Test(timeout=100000L)
    public void testDeleteWithFullRow() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        ArrayList<PartialRow> rows = new ArrayList<PartialRow>();
        for (int i = 0; i < 25; ++i) {
            Insert insert = this.createInsert(table, i);
            rows.add(insert.getRow());
            session.apply((Operation)insert);
        }
        session.flush();
        for (PartialRow row : rows) {
            Delete del = table.newDelete();
            del.setRow(row);
            session.apply((Operation)del);
        }
        session.flush();
        Assert.assertEquals((long)0L, (long)session.countPendingErrors());
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((KuduScanner)this.client.newScannerBuilder(table).build()));
    }

    @Test(timeout=100000L)
    public void testEmptyFlush() throws Exception {
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        List result = session.flush();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test(timeout=100000L)
    public void testConcurrentFlushes() throws Exception {
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        int numTablets = 4;
        int numRowsPerTablet = 100;
        for (int i = 1; i < numTablets; ++i) {
            PartialRow split = basicSchema.newPartialRow();
            split.addInt(0, i * numRowsPerTablet);
            builder.addSplitRow(split);
        }
        KuduTable table = this.client.createTable(tableName, basicSchema, builder);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        session.setFlushInterval(1);
        for (int i = 0; i < numRowsPerTablet; ++i) {
            for (int j = 0; j < numTablets; ++j) {
                session.apply((Operation)this.createInsert(table, i + numRowsPerTablet * j));
            }
            session.flush();
        }
    }

    @Test(timeout=10000L)
    public void testOverWritingValues() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        Insert insert = this.createInsert(table, 0);
        PartialRow row = insert.getRow();
        int magicNumber = 9999;
        row.addInt(1, magicNumber);
        row.addInt(2, magicNumber);
        row.addBoolean(4, false);
        for (int i = 0; i <= magicNumber; ++i) {
            row.addString(3, i + "");
        }
        Assert.assertEquals((long)5L, (long)row.getVarLengthData().size());
        session.apply((Operation)insert);
        KuduScanner scanner = this.client.newScannerBuilder(table).build();
        RowResult rr = (RowResult)scanner.nextRows().next();
        Assert.assertEquals((long)magicNumber, (long)rr.getInt(1));
        Assert.assertEquals((long)magicNumber, (long)rr.getInt(2));
        Assert.assertEquals((Object)(magicNumber + ""), (Object)rr.getString(3));
        Assert.assertEquals((Object)false, (Object)rr.getBoolean(4));
        try {
            row.addInt(1, 0);
            Assert.fail((String)"Row should be frozen and throw");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testUpsert() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        Assert.assertFalse((boolean)session.apply((Operation)this.createUpsert(table, 1, 1, false)).hasRowError());
        List rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((long)1L, (long)rowStrings.size());
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=1, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
        Assert.assertFalse((boolean)session.apply((Operation)this.createUpsert(table, 1, 2, false)).hasRowError());
        rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=2, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
    }

    @Test(timeout=10000L)
    public void testInsertIgnoreAfterInsertHasNoRowError() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        session.apply((Operation)this.createInsert(table, 1));
        session.apply((Operation)this.createUpsert(table, 1, 1, false));
        session.apply((Operation)this.createInsertIgnore(table, 1));
        List results = session.flush();
        for (OperationResponse result : results) {
            Assert.assertFalse((String)result.toString(), (boolean)result.hasRowError());
        }
        List rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((long)1L, (long)rowStrings.size());
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=1, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
    }

    @Test(timeout=10000L)
    public void testInsertAfterInsertIgnoreHasRowError() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        session.apply((Operation)this.createInsertIgnore(table, 1));
        session.apply((Operation)this.createInsert(table, 1));
        List results = session.flush();
        Assert.assertFalse((String)((OperationResponse)results.get(0)).toString(), (boolean)((OperationResponse)results.get(0)).hasRowError());
        Assert.assertTrue((String)((OperationResponse)results.get(1)).toString(), (boolean)((OperationResponse)results.get(1)).hasRowError());
        Assert.assertTrue((boolean)((OperationResponse)results.get(1)).getRowError().getErrorStatus().isAlreadyPresent());
        List rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((long)1L, (long)rowStrings.size());
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=2, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
    }

    @Test(timeout=10000L)
    public void testInsertIgnore() throws Exception {
        KuduTable table = this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        KuduSession session = this.client.newSession();
        Assert.assertFalse((boolean)session.apply((Operation)this.createInsertIgnore(table, 1)).hasRowError());
        List rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=2, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
        Assert.assertFalse((boolean)session.apply((Operation)this.createInsertIgnore(table, 1)).hasRowError());
        rowStrings = ClientTestUtil.scanTableToStrings((KuduTable)table, (KuduPredicate[])new KuduPredicate[0]);
        Assert.assertEquals((Object)"INT32 key=1, INT32 column1_i=2, INT32 column2_i=3, STRING column3_s=a string, BOOL column4_b=true", rowStrings.get(0));
    }

    @Test(timeout=10000L)
    public void testInsertManualFlushNonCoveredRange() throws Exception {
        CreateTableOptions createOptions = ClientTestUtil.getBasicTableOptionsWithNonCoveredRange();
        createOptions.setNumReplicas(1);
        this.client.createTable(tableName, basicSchema, createOptions);
        KuduTable table = this.client.openTable(tableName);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        ImmutableList nonCoveredKeys = ImmutableList.of((Object)350, (Object)300, (Object)199, (Object)150, (Object)100, (Object)-1, (Object)-50);
        Iterator iterator = nonCoveredKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            Assert.assertNull((Object)session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key)));
        }
        List results = session.flush();
        Assert.assertEquals((long)nonCoveredKeys.size(), (long)results.size());
        for (OperationResponse result : results) {
            Assert.assertTrue((boolean)result.hasRowError());
            Assert.assertTrue((boolean)result.getRowError().getErrorStatus().isNotFound());
        }
        for (int key = 90; key < 110; ++key) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key));
        }
        results = session.flush();
        int failures = 0;
        for (OperationResponse result : results) {
            if (!result.hasRowError()) continue;
            ++failures;
            Assert.assertTrue((boolean)result.getRowError().getErrorStatus().isNotFound());
        }
        Assert.assertEquals((long)10L, (long)failures);
    }

    @Test(timeout=10000L)
    public void testInsertManualFlushResponseOrder() throws Exception {
        CreateTableOptions createOptions = ClientTestUtil.getBasicTableOptionsWithNonCoveredRange();
        createOptions.setNumReplicas(1);
        this.client.createTable(tableName, basicSchema, createOptions);
        KuduTable table = this.client.openTable(tableName);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        for (int i = 0; i < 10; ++i) {
            Assert.assertNull((Object)session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)(100 + i * 10))));
            Assert.assertNull((Object)session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)(200 + i * 10))));
        }
        List results = session.flush();
        Assert.assertEquals((long)20L, (long)results.size());
        for (int i = 0; i < 20; ++i) {
            OperationResponse result = (OperationResponse)results.get(i);
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)result.hasRowError());
                Assert.assertTrue((boolean)result.getRowError().getErrorStatus().isNotFound());
                continue;
            }
            Assert.assertFalse((boolean)result.hasRowError());
        }
    }

    @Test(timeout=10000L)
    public void testInsertAutoFlushSyncNonCoveredRange() throws Exception {
        CreateTableOptions createOptions = ClientTestUtil.getBasicTableOptionsWithNonCoveredRange();
        createOptions.setNumReplicas(1);
        this.client.createTable(tableName, basicSchema, createOptions);
        KuduTable table = this.client.openTable(tableName);
        KuduSession session = this.client.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        ImmutableList nonCoveredKeys = ImmutableList.of((Object)350, (Object)300, (Object)199, (Object)150, (Object)100, (Object)-1, (Object)-50);
        Iterator iterator = nonCoveredKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            OperationResponse response = session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key));
            Assert.assertTrue((boolean)response.hasRowError());
            Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isNotFound());
        }
    }

    @Test(timeout=10000L)
    public void testInsertAutoFlushBackgroundNonCoveredRange() throws Exception {
        CreateTableOptions createOptions = ClientTestUtil.getBasicTableOptionsWithNonCoveredRange();
        createOptions.setNumReplicas(1);
        this.client.createTable(tableName, basicSchema, createOptions);
        KuduTable table = this.client.openTable(tableName);
        AsyncKuduSession session = this.asyncClient.newSession();
        session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        ImmutableList nonCoveredKeys = ImmutableList.of((Object)350, (Object)300, (Object)199, (Object)150, (Object)100, (Object)-1, (Object)-50);
        Iterator iterator = nonCoveredKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            OperationResponse result = (OperationResponse)session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key)).join(5000L);
            Assert.assertTrue((boolean)result.hasRowError());
            Assert.assertTrue((boolean)result.getRowError().getErrorStatus().isNotFound());
        }
        RowErrorsAndOverflowStatus errors = session.getPendingErrors();
        Assert.assertEquals((long)nonCoveredKeys.size(), (long)errors.getRowErrors().length);
        for (RowError error : errors.getRowErrors()) {
            Assert.assertTrue((boolean)error.getErrorStatus().isNotFound());
        }
        for (int key = 90; key < 110; ++key) {
            session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key));
        }
        session.flush().join(5000L);
        errors = session.getPendingErrors();
        Assert.assertEquals((long)10L, (long)errors.getRowErrors().length);
        for (RowError error : errors.getRowErrors()) {
            Assert.assertTrue((boolean)error.getErrorStatus().isNotFound());
        }
    }

    private Insert createInsert(KuduTable table, int key) {
        return ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key);
    }

    private Upsert createUpsert(KuduTable table, int key, int secondVal, boolean hasNull) {
        Upsert upsert = table.newUpsert();
        PartialRow row = upsert.getRow();
        row.addInt(0, key);
        row.addInt(1, secondVal);
        row.addInt(2, 3);
        if (hasNull) {
            row.setNull(3);
        } else {
            row.addString(3, "a string");
        }
        row.addBoolean(4, true);
        return upsert;
    }

    private Delete createDelete(KuduTable table, int key) {
        Delete delete = table.newDelete();
        PartialRow row = delete.getRow();
        row.addInt(0, key);
        return delete;
    }

    protected InsertIgnore createInsertIgnore(KuduTable table, int key) {
        InsertIgnore insertIgnore = table.newInsertIgnore();
        PartialRow row = insertIgnore.getRow();
        row.addInt(0, key);
        row.addInt(1, 2);
        row.addInt(2, 3);
        row.addString(3, "a string");
        row.addBoolean(4, true);
        return insertIgnore;
    }
}

