/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPartitioner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NonCoveredRangeException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestKuduPartitioner {
    private KuduClient client;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
    }

    @Test
    public void testPartitioner() throws Exception {
        Schema basicSchema = ClientTestUtil.getBasicSchema();
        int numRanges = 3;
        int numHashPartitions = 3;
        String tableName = "TestPartitioner";
        ArrayList<PartialRow> splitRows = new ArrayList<PartialRow>();
        for (int split : Arrays.asList(3333, 6666)) {
            PartialRow row = basicSchema.newPartialRow();
            row.addInt("key", split);
            splitRows.add(row);
        }
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.addHashPartitions(Collections.singletonList("key"), 3);
        createOptions.setRangePartitionColumns(Collections.singletonList("key"));
        for (PartialRow row : splitRows) {
            createOptions.addSplitRow(row);
        }
        KuduTable table = this.client.createTable("TestPartitioner", basicSchema, createOptions);
        Schema schema = table.getSchema();
        KuduPartitioner part = new KuduPartitioner.KuduPartitionerBuilder(table).build();
        Assert.assertEquals((long)9L, (long)part.numPartitions());
        int numRowsToPartition = 10000;
        int[] countsByPartition = new int[part.numPartitions()];
        Arrays.fill(countsByPartition, 0);
        for (int i = 0; i < numRowsToPartition; ++i) {
            int partIndex;
            PartialRow row = schema.newPartialRow();
            row.addInt("key", i);
            int n = partIndex = part.partitionRow(row);
            countsByPartition[n] = countsByPartition[n] + 1;
        }
        int expectedPerPartition = numRowsToPartition / part.numPartitions();
        int fuzziness = expectedPerPartition / 10;
        int minPerPartition = expectedPerPartition - fuzziness;
        int maxPerPartition = expectedPerPartition + fuzziness;
        for (int i = 0; i < part.numPartitions(); ++i) {
            Assert.assertTrue((minPerPartition <= countsByPartition[i] ? 1 : 0) != 0);
            Assert.assertTrue((maxPerPartition >= countsByPartition[i] ? 1 : 0) != 0);
        }
        AlterTableOptions alterOptions = new AlterTableOptions();
        alterOptions.dropRangePartition(basicSchema.newPartialRow(), (PartialRow)splitRows.get(0));
        alterOptions.dropRangePartition((PartialRow)splitRows.get(1), basicSchema.newPartialRow());
        this.client.alterTable("TestPartitioner", alterOptions);
        Assert.assertEquals((long)9L, (long)part.numPartitions());
        PartialRow row = schema.newPartialRow();
        row.addInt("key", 1000);
        Assert.assertEquals((long)0L, (long)part.partitionRow(row));
        part = new KuduPartitioner.KuduPartitionerBuilder(table).build();
        Assert.assertEquals((long)3L, (long)part.numPartitions());
    }

    @Test
    public void testPartitionerNonCoveredRange() throws Exception {
        Schema basicSchema = ClientTestUtil.getBasicSchema();
        int numHashPartitions = 3;
        String tableName = "TestPartitionerNonCoveredRange";
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.addHashPartitions(Collections.singletonList("key"), 3);
        createOptions.setRangePartitionColumns(Collections.singletonList("key"));
        PartialRow lower = basicSchema.newPartialRow();
        lower.addInt("key", 1000);
        PartialRow upper = basicSchema.newPartialRow();
        upper.addInt("key", 2000);
        createOptions.addRangePartition(lower, upper);
        KuduTable table = this.client.createTable("TestPartitionerNonCoveredRange", basicSchema, createOptions);
        Schema schema = table.getSchema();
        KuduPartitioner part = new KuduPartitioner.KuduPartitionerBuilder(table).build();
        try {
            PartialRow under = schema.newPartialRow();
            under.addInt("key", 999);
            part.partitionRow(under);
            Assert.fail((String)"partitionRow did not throw a NonCoveredRangeException");
        }
        catch (NonCoveredRangeException under) {
            // empty catch block
        }
        try {
            PartialRow over = schema.newPartialRow();
            over.addInt("key", 999);
            part.partitionRow(over);
            Assert.fail((String)"partitionRow did not throw a NonCoveredRangeException");
        }
        catch (NonCoveredRangeException nonCoveredRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testBuildTimeout() throws Exception {
        Schema basicSchema = ClientTestUtil.getBasicSchema();
        String tableName = "TestBuildTimeout";
        CreateTableOptions createOptions = new CreateTableOptions();
        createOptions.addHashPartitions(Collections.singletonList("key"), 3);
        createOptions.setRangePartitionColumns(Collections.singletonList("key"));
        KuduTable table = this.client.createTable(tableName, basicSchema, createOptions);
        this.harness.killAllMasterServers();
        int timeoutMs = 2000;
        long now = System.currentTimeMillis();
        try {
            new KuduPartitioner.KuduPartitionerBuilder(table).buildTimeout((long)timeoutMs).build();
            Assert.fail((String)"No NonRecoverableException was thrown");
        }
        catch (NonRecoverableException ex) {
            Assert.assertTrue((boolean)ex.getMessage().startsWith("cannot complete before timeout"));
        }
        long elapsed = System.currentTimeMillis() - now;
        long upperBound = (long)timeoutMs * 2L;
        Assert.assertTrue((String)String.format("Elapsed time %d exceeded upper bound %d", elapsed, upperBound), (elapsed <= upperBound ? 1 : 0) != 0);
    }

    @Test
    public void testTableCache() throws Exception {
        String tableName = "TestTableCache";
        KuduTable table = this.client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicTableOptionsWithNonCoveredRange());
        KuduPartitioner partitioner = new KuduPartitioner.KuduPartitionerBuilder(table).build();
        this.harness.killAllMasterServers();
        KuduPartitioner partitionerFromCache = new KuduPartitioner.KuduPartitionerBuilder(table).build();
        Assert.assertEquals((long)partitioner.numPartitions(), (long)partitionerFromCache.numPartitions());
    }
}

