/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.noop.NoopCounter;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduMetrics;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestKuduMetrics {
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Test
    public void testDisabledMetrics() throws Exception {
        KuduMetrics.setEnabled((boolean)false);
        Counter foo = KuduMetrics.counter((KuduMetrics.KuduMetricId)KuduMetrics.RPC_RESPONSE_METRIC, (String[])new String[]{"client.id", "foo"});
        Assert.assertTrue((boolean)(foo instanceof NoopCounter));
        foo.increment();
        Assert.assertEquals((long)0L, (long)((int)foo.count()));
        Assert.assertEquals((long)0L, (long)KuduMetrics.numMetrics());
    }

    @Test
    public void testClientIdFilter() throws Exception {
        KuduClient c1 = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
        KuduClient c2 = new KuduClient.KuduClientBuilder(this.harness.getMasterAddressesAsString()).build();
        c1.createTable("c1-table", ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        c2.createTable("c2-table", ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
        String c1Id = c1.getClientId();
        String c2Id = c1.getClientId();
        int totalNumMetrics = KuduMetrics.numMetrics();
        int c1NumMetrics = KuduMetrics.numMetrics((String[])new String[]{"client.id", c1Id});
        int c2NumMetrics = KuduMetrics.numMetrics((String[])new String[]{"client.id", c2Id});
        KuduMetrics.logMetrics();
        Assert.assertEquals((long)totalNumMetrics, (long)(c1NumMetrics + c2NumMetrics));
        KuduMetrics.setEnabled((boolean)false);
        Assert.assertEquals((long)0L, (long)KuduMetrics.numMetrics());
        KuduMetrics.setEnabled((boolean)true);
        Assert.assertEquals((long)0L, (long)KuduMetrics.numMetrics());
    }
}

