/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Rule;
import org.junit.Test;

public class TestHandleTooBusy {
    private static final String TABLE_NAME = "TestHandleTooBusy";
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().addMasterServerFlag("--rpc_service_queue_length=1").addMasterServerFlag("--rpc_num_service_threads=3").addMasterServerFlag("--master_inject_latency_on_tablet_lookups_ms=100");
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Test(timeout=60000L)
    public void testMasterLookupOverflow() throws Exception {
        this.harness.getClient().createTable(TABLE_NAME, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        ExecutorService exec = Executors.newCachedThreadPool();
        ArrayList futures = Lists.newArrayList();
        for (int thr = 0; thr < 10; ++thr) {
            futures.add(exec.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int i = 0; i < 5; ++i) {
                        try (KuduClient c = new KuduClient.KuduClientBuilder(TestHandleTooBusy.this.harness.getMasterAddressesAsString()).build();){
                            KuduTable table = c.openTable(TestHandleTooBusy.TABLE_NAME);
                            for (int j = 0; j < 5; ++j) {
                                KuduScanToken.KuduScanTokenBuilder scanBuilder = c.newScanTokenBuilder(table);
                                scanBuilder.build();
                                c.asyncClient.emptyTabletsCacheForTable(table.getTableId());
                            }
                            continue;
                        }
                    }
                    return null;
                }
            }));
        }
        for (Future f : futures) {
            f.get();
        }
    }
}

