/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.client.ErrorCollector;
import org.apache.kudu.client.RowError;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.Status;
import org.apache.kudu.test.junit.RetryRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestErrorCollector {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testErrorCollector() {
        int maxErrors = 10;
        ErrorCollector collector = new ErrorCollector(maxErrors);
        int countToTest = 0;
        Assert.assertEquals((long)countToTest, (long)collector.countErrors());
        RowErrorsAndOverflowStatus reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertFalse((boolean)reos.isOverflowed());
        Assert.assertEquals((long)countToTest, (long)reos.getRowErrors().length);
        countToTest = 1;
        collector.addError(this.createRowError(countToTest));
        Assert.assertEquals((long)countToTest, (long)collector.countErrors());
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertFalse((boolean)reos.isOverflowed());
        Assert.assertEquals((long)countToTest, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)countToTest, (long)reos.getRowErrors()[0].getErrorStatus().getPosixCode());
        countToTest = maxErrors;
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)countToTest, (long)collector.countErrors());
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertFalse((boolean)reos.isOverflowed());
        Assert.assertEquals((long)countToTest, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[9].getErrorStatus().getPosixCode());
        countToTest = 95;
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)maxErrors, (long)collector.countErrors());
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertTrue((boolean)reos.isOverflowed());
        Assert.assertEquals((long)maxErrors, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[9].getErrorStatus().getPosixCode());
        countToTest = 95;
        collector = new ErrorCollector(maxErrors);
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)maxErrors, (long)collector.countErrors());
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertTrue((boolean)reos.isOverflowed());
        Assert.assertEquals((long)maxErrors, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[9].getErrorStatus().getPosixCode());
        countToTest = 10;
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)maxErrors, (long)collector.countErrors());
        collector.resize(2 * maxErrors);
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertFalse((boolean)reos.isOverflowed());
        Assert.assertEquals((long)maxErrors, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[9].getErrorStatus().getPosixCode());
        countToTest = 11;
        collector = new ErrorCollector(maxErrors);
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)maxErrors, (long)collector.countErrors());
        collector.resize(2 * maxErrors);
        collector.addError(this.createRowError(42));
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertTrue((boolean)reos.isOverflowed());
        Assert.assertEquals((long)11L, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)42L, (long)reos.getRowErrors()[10].getErrorStatus().getPosixCode());
        countToTest = 5;
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)countToTest, (long)collector.countErrors());
        collector.resize(maxErrors);
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertFalse((boolean)reos.isOverflowed());
        Assert.assertEquals((long)countToTest, (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[4].getErrorStatus().getPosixCode());
        countToTest = 5;
        this.fillCollectorWith(collector, countToTest);
        Assert.assertEquals((long)countToTest, (long)collector.countErrors());
        collector.resize(countToTest - 1);
        reos = collector.getErrors();
        Assert.assertEquals((long)0L, (long)collector.countErrors());
        Assert.assertTrue((boolean)reos.isOverflowed());
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors().length);
        Assert.assertEquals((long)(countToTest - 1), (long)reos.getRowErrors()[3].getErrorStatus().getPosixCode());
    }

    private void fillCollectorWith(ErrorCollector collector, int errorsToAdd) {
        for (int i = 0; i < errorsToAdd; ++i) {
            collector.addError(this.createRowError(i));
        }
    }

    private RowError createRowError(int id) {
        return new RowError(Status.NotAuthorized((String)"test", (int)id), null, "test");
    }
}

