/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.ColumnRangePredicate;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.tserver.Tserver;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestColumnRangePredicate {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testRawLists() {
        ColumnSchema col1 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.INT32).build();
        ColumnSchema col2 = new ColumnSchema.ColumnSchemaBuilder("col2", Type.STRING).build();
        ColumnSchema col3 = new ColumnSchema.ColumnSchemaBuilder("col3", Type.DECIMAL).typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(6).scale(2).build()).build();
        ColumnRangePredicate pred1 = new ColumnRangePredicate(col1);
        pred1.setLowerBound(1);
        ColumnRangePredicate pred2 = new ColumnRangePredicate(col1);
        pred2.setUpperBound(2);
        ColumnRangePredicate pred3 = new ColumnRangePredicate(col2);
        pred3.setLowerBound("aaa");
        pred3.setUpperBound("bbb");
        ColumnRangePredicate pred4 = new ColumnRangePredicate(col3);
        pred4.setLowerBound(BigDecimal.valueOf(12345L, 2));
        ArrayList preds = Lists.newArrayList((Object[])new ColumnRangePredicate[]{pred1, pred2, pred3, pred4});
        byte[] rawPreds = ColumnRangePredicate.toByteArray((List)preds);
        List decodedPreds = null;
        try {
            decodedPreds = ColumnRangePredicate.fromByteArray((byte[])rawPreds);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Couldn't decode: " + e.getMessage()));
        }
        Assert.assertEquals((long)4L, (long)decodedPreds.size());
        Assert.assertEquals((Object)col1.getName(), (Object)((Tserver.ColumnRangePredicatePB)decodedPreds.get(0)).getColumn().getName());
        Assert.assertEquals((long)1L, (long)Bytes.getInt((byte[])((Tserver.ColumnRangePredicatePB)decodedPreds.get(0)).getLowerBound().toByteArray()));
        Assert.assertFalse((boolean)((Tserver.ColumnRangePredicatePB)decodedPreds.get(0)).hasInclusiveUpperBound());
        Assert.assertEquals((Object)col1.getName(), (Object)((Tserver.ColumnRangePredicatePB)decodedPreds.get(1)).getColumn().getName());
        Assert.assertEquals((long)2L, (long)Bytes.getInt((byte[])((Tserver.ColumnRangePredicatePB)decodedPreds.get(1)).getInclusiveUpperBound().toByteArray()));
        Assert.assertFalse((boolean)((Tserver.ColumnRangePredicatePB)decodedPreds.get(1)).hasLowerBound());
        Assert.assertEquals((Object)col2.getName(), (Object)((Tserver.ColumnRangePredicatePB)decodedPreds.get(2)).getColumn().getName());
        Assert.assertEquals((Object)"aaa", (Object)Bytes.getString((byte[])((Tserver.ColumnRangePredicatePB)decodedPreds.get(2)).getLowerBound().toByteArray()));
        Assert.assertEquals((Object)"bbb", (Object)Bytes.getString((byte[])((Tserver.ColumnRangePredicatePB)decodedPreds.get(2)).getInclusiveUpperBound().toByteArray()));
        Assert.assertEquals((Object)col3.getName(), (Object)((Tserver.ColumnRangePredicatePB)decodedPreds.get(3)).getColumn().getName());
        Assert.assertEquals((long)12345L, (long)Bytes.getInt((byte[])((Tserver.ColumnRangePredicatePB)decodedPreds.get(3)).getLowerBound().toByteArray()));
        Assert.assertFalse((boolean)((Tserver.ColumnRangePredicatePB)decodedPreds.get(0)).hasInclusiveUpperBound());
    }
}

