/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.apache.kudu.client.ListTabletServersResponse;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestAuthnTokenReacquireOpen {
    private static final String TABLE_NAME = "TestAuthnTokenReacquireOpen-table";
    private static final int TOKEN_TTL_SEC = 1;
    private static final int OP_TIMEOUT_MS = 60000;
    private static final int KEEPALIVE_TIME_MS = 120000;
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().numMasterServers(1).enableKerberos().addMasterServerFlag(String.format("--authn_token_validity_seconds=%d", 1)).addMasterServerFlag(String.format("--rpc_default_keepalive_time_ms=%d", 120000)).addTabletServerFlag(String.format("--rpc_default_keepalive_time_ms=%d", 120000)).addTabletServerFlag("--rpc_inject_invalid_authn_token_ratio=0.5");
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    private void dropConnections() {
        for (Connection c : this.asyncClient.getConnectionListCopy()) {
            c.disconnect();
        }
    }

    private static void expireToken() throws InterruptedException {
        Thread.sleep(1000L);
    }

    @Test
    public void test() throws Exception {
        ListTabletServersResponse response = this.client.listTabletServers();
        Assert.assertNotNull((Object)response);
        this.dropConnections();
        ListTablesResponse tableList = this.client.getTablesList(null);
        Assert.assertNotNull((Object)tableList);
        Assert.assertTrue((boolean)tableList.getTablesList().isEmpty());
        this.client.createTable(TABLE_NAME, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        Assert.assertTrue((boolean)this.client.tableExists(TABLE_NAME));
        TestAuthnTokenReacquireOpen.expireToken();
        KuduTable scanTable = this.client.openTable(TABLE_NAME);
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)new AsyncKuduScanner.AsyncKuduScannerBuilder(this.asyncClient, scanTable).scanRequestTimeout(60000L)).build();
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner));
        this.client.deleteTable(TABLE_NAME);
        Assert.assertFalse((boolean)this.client.tableExists(TABLE_NAME));
    }
}

