/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.KeyRange;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.apache.kudu.client.ListTabletServersResponse;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.Status;
import org.apache.kudu.security.Token;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuthTokenReacquire {
    private static final Logger LOG = LoggerFactory.getLogger(TestAuthTokenReacquire.class);
    private static final String TABLE_NAME = "TestAuthTokenReacquire-table";
    private static final int TOKEN_TTL_SEC = 1;
    private static final int OP_TIMEOUT_MS = 60000;
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    private static final MiniKuduCluster.MiniKuduClusterBuilder clusterBuilder = KuduTestHarness.getBaseClusterBuilder().enableKerberos().addMasterServerFlag(String.format("--authn_token_validity_seconds=%d", 1)).addMasterServerFlag(String.format("--authz_token_validity_seconds=%d", 1)).addMasterServerFlag("--rpc_inject_invalid_authn_token_ratio=0.5").addTabletServerFlag("--rpc_inject_invalid_authn_token_ratio=0.5").addTabletServerFlag("--tserver_enforce_access_control=true").addTabletServerFlag("--tserver_inject_invalid_authz_token_ratio=0.5");
    private KuduClient client;
    private AsyncKuduClient asyncClient;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness(clusterBuilder);

    @Before
    public void setUp() {
        this.client = this.harness.getClient();
        this.asyncClient = this.harness.getAsyncClient();
    }

    private void dropConnections() {
        for (Connection c : this.asyncClient.getConnectionListCopy()) {
            c.disconnect();
        }
    }

    private void dropConnectionsAndExpireTokens() throws InterruptedException {
        this.dropConnections();
        this.expireTokens();
    }

    private void expireTokens() throws InterruptedException {
        Thread.sleep(2000L);
    }

    @Test
    public void testBasicMasterOperations() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final Map exceptions = Collections.synchronizedMap(new HashMap());
        int i = 0;
        while (i < 8) {
            final int n = i++;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String tableName = "TestAuthTokenReacquire-table-" + n;
                    try {
                        block7: {
                            block6: {
                                ListTabletServersResponse response = TestAuthTokenReacquire.this.client.listTabletServers();
                                Assert.assertNotNull((Object)response);
                                TestAuthTokenReacquire.this.dropConnectionsAndExpireTokens();
                                ListTablesResponse tableList = TestAuthTokenReacquire.this.client.getTablesList(tableName);
                                Assert.assertNotNull((Object)tableList);
                                Assert.assertTrue((boolean)tableList.getTablesList().isEmpty());
                                TestAuthTokenReacquire.this.dropConnectionsAndExpireTokens();
                                try {
                                    TestAuthTokenReacquire.this.client.createTable(tableName, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
                                }
                                catch (KuduException ex) {
                                    Status exStatus = ex.getStatus();
                                    if (exStatus.isAlreadyPresent() || exStatus.isServiceUnavailable()) break block6;
                                    throw ex;
                                }
                            }
                            TestAuthTokenReacquire.this.dropConnectionsAndExpireTokens();
                            KuduTable table = TestAuthTokenReacquire.this.client.openTable(tableName);
                            Assert.assertEquals((long)basicSchema.getColumnCount(), (long)table.getSchema().getColumnCount());
                            TestAuthTokenReacquire.this.dropConnectionsAndExpireTokens();
                            try {
                                TestAuthTokenReacquire.this.client.deleteTable(tableName);
                            }
                            catch (KuduException ex) {
                                if (ex.getStatus().isNotFound()) break block7;
                                throw ex;
                            }
                        }
                        Assert.assertFalse((boolean)TestAuthTokenReacquire.this.client.tableExists(tableName));
                    }
                    catch (Throwable e) {
                        exceptions.put(n, e);
                    }
                }
            });
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        if (!exceptions.isEmpty()) {
            for (Map.Entry entry : exceptions.entrySet()) {
                LOG.error(String.format("exception in thread %s:", entry.getKey()), (Throwable)entry.getValue());
            }
            Assert.fail((String)"test failed: unexpected errors");
        }
    }

    private int countRowsInTable(KuduTable table) throws Exception {
        AsyncKuduScanner scanner = ((AsyncKuduScanner.AsyncKuduScannerBuilder)new AsyncKuduScanner.AsyncKuduScannerBuilder(this.asyncClient, table).scanRequestTimeout(60000L)).build();
        return ClientTestUtil.countRowsInScan((AsyncKuduScanner)scanner);
    }

    private void insertRowWithKey(KuduSession session, KuduTable table, int key) throws Exception {
        session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)table, (int)key));
        session.flush();
        RowErrorsAndOverflowStatus errors = session.getPendingErrors();
        Assert.assertFalse((boolean)errors.isOverflowed());
        Assert.assertEquals((long)0L, (long)session.countPendingErrors());
    }

    private List<KeyRange> splitKeyRange(KuduTable table) throws Exception {
        return (List)table.getAsyncClient().getTableKeyRanges(table, null, null, null, null, AsyncKuduClient.FETCH_TABLETS_PER_RANGE_LOOKUP, 1L, 50000L).join();
    }

    @Test
    public void testBasicWorkflow() throws Exception {
        KuduTable table = this.client.createTable(TABLE_NAME, basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        String tableId = table.getTableId();
        int key = 0;
        Token.SignedTokenPB originalToken = this.asyncClient.securityContext.getAuthenticationToken();
        this.dropConnectionsAndExpireTokens();
        KuduSession session = this.client.newSession();
        session.setTimeoutMillis(60000L);
        this.insertRowWithKey(session, table, ++key);
        Assert.assertFalse((boolean)this.asyncClient.securityContext.getAuthenticationToken().equals((Object)originalToken));
        originalToken = this.asyncClient.getAuthzToken(tableId);
        this.expireTokens();
        this.insertRowWithKey(session, table, ++key);
        Assert.assertFalse((boolean)this.asyncClient.getAuthzToken(tableId).equals((Object)originalToken));
        originalToken = this.asyncClient.securityContext.getAuthenticationToken();
        this.dropConnectionsAndExpireTokens();
        KuduTable scanTable = this.client.openTable(TABLE_NAME);
        Assert.assertEquals((long)key, (long)this.countRowsInTable(scanTable));
        Assert.assertFalse((boolean)this.asyncClient.securityContext.getAuthenticationToken().equals((Object)originalToken));
        originalToken = this.asyncClient.getAuthzToken(tableId);
        this.expireTokens();
        Assert.assertEquals((long)key, (long)this.countRowsInTable(scanTable));
        Assert.assertFalse((boolean)this.asyncClient.getAuthzToken(tableId).equals((Object)originalToken));
        originalToken = this.asyncClient.getAuthzToken(tableId);
        this.expireTokens();
        Assert.assertFalse((boolean)this.splitKeyRange(scanTable).isEmpty());
        Assert.assertFalse((boolean)this.asyncClient.getAuthzToken(tableId).equals((Object)originalToken));
        originalToken = this.asyncClient.securityContext.getAuthenticationToken();
        this.dropConnectionsAndExpireTokens();
        this.client.deleteTable(TABLE_NAME);
        Assert.assertFalse((boolean)this.client.tableExists(TABLE_NAME));
        Assert.assertFalse((boolean)this.asyncClient.securityContext.getAuthenticationToken().equals((Object)originalToken));
    }
}

