/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.Batch;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTabletsRequest;
import org.apache.kudu.client.ListTabletsResponse;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PleaseThrottleException;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.RpcProxy;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.apache.kudu.tserver.Tserver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncKuduSession {
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncKuduSession.class);
    private static final String TABLE_NAME = TestAsyncKuduSession.class.getName();
    private static final Schema SCHEMA = ClientTestUtil.getBasicSchema();
    private static final String INJECTED_TS_ERROR = "injected error for test";
    private AsyncKuduClient client;
    private AsyncKuduSession session;
    private KuduTable table;
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    @Before
    public void setUp() throws Exception {
        this.client = this.harness.getAsyncClient();
        this.session = this.client.newSession();
        this.table = this.harness.getClient().createTable(TABLE_NAME, SCHEMA, ClientTestUtil.getBasicCreateTableOptions());
    }

    @Test(timeout=100000L)
    public void testBackgroundErrors() throws Exception {
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        this.session.setFlushInterval(10);
        try {
            Batch.injectTabletServerErrorAndLatency((Tserver.TabletServerErrorPB)this.makeTabletServerError(), (int)0);
            OperationResponse resp = (OperationResponse)this.session.apply((Operation)this.createInsert(1)).join(50000L);
            Assert.assertTrue((boolean)resp.hasRowError());
            Assert.assertTrue((boolean)resp.getRowError().getErrorStatus().getMessage().contains(INJECTED_TS_ERROR));
            Assert.assertEquals((long)1L, (long)this.session.countPendingErrors());
        }
        finally {
            Batch.injectTabletServerErrorAndLatency(null, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testBatchErrorCauseSessionStuck() throws Exception {
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        this.session.setFlushInterval(100);
        try {
            Batch.injectTabletServerErrorAndLatency((Tserver.TabletServerErrorPB)this.makeTabletServerError(), (int)200);
            Deferred resp1 = this.session.apply((Operation)this.createInsert(1));
            Thread.sleep(120L);
            Deferred resp2 = this.session.apply((Operation)this.createInsert(2));
            OperationResponse resp = (OperationResponse)resp1.join(50000L);
            Assert.assertTrue((boolean)resp.hasRowError());
            Assert.assertTrue((boolean)resp.getRowError().getErrorStatus().getMessage().contains(INJECTED_TS_ERROR));
            resp = (OperationResponse)resp2.join(50000L);
            Assert.assertTrue((boolean)resp.hasRowError());
            Assert.assertTrue((boolean)resp.getRowError().getErrorStatus().getMessage().contains(INJECTED_TS_ERROR));
            Assert.assertFalse((boolean)this.session.hasPendingOperations());
        }
        finally {
            Batch.injectTabletServerErrorAndLatency(null, (int)0);
        }
    }

    @Test(timeout=100000L)
    public void testGetTableLocationsErrorCausesStuckSession() throws Exception {
        Insert insert = this.createInsert(1);
        this.session.apply((Operation)insert).join(50000L);
        RemoteTablet rt = this.client.getTableLocationEntry(this.table.getTableId(), insert.partitionKey()).getTablet();
        String tabletId = rt.getTabletId();
        RpcProxy proxy = this.client.newRpcProxy(rt.getLeaderServerInfo());
        this.client.deleteTable(TABLE_NAME).join();
        while (true) {
            ListTabletsRequest req = new ListTabletsRequest(this.client.getTimer(), 10000L);
            Deferred d = req.getDeferred();
            proxy.sendRpc((KuduRpc)req);
            ListTabletsResponse resp = (ListTabletsResponse)d.join();
            if (!resp.getTabletsList().contains(tabletId)) break;
            Thread.sleep(100L);
        }
        OperationResponse response = (OperationResponse)this.session.apply((Operation)this.createInsert(1)).join(50000L);
        Assert.assertTrue((boolean)response.hasRowError());
        Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isNotFound());
    }

    @Test
    public void testInsertIntoUnavailableTablet() throws Exception {
        this.harness.killAllTabletServers();
        this.session.setTimeoutMillis(1L);
        OperationResponse response = (OperationResponse)this.session.apply((Operation)this.createInsert(1)).join();
        Assert.assertTrue((boolean)response.hasRowError());
        LOG.debug("response error: {}", (Object)response.getRowError());
        Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isTimedOut());
        this.session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        Insert insert = this.createInsert(1);
        this.session.apply((Operation)insert);
        List responses = (List)this.session.flush().join();
        Assert.assertEquals((long)1L, (long)responses.size());
        response = (OperationResponse)responses.get(0);
        Assert.assertTrue((boolean)response.hasRowError());
        LOG.debug("response error: {}", (Object)response.getRowError());
        Assert.assertTrue((boolean)response.getRowError().getErrorStatus().isTimedOut());
    }

    @Test(timeout=100000L)
    public void testRestartBetweenWrites() throws Exception {
        KuduTable nonReplicatedTable = this.harness.getClient().createTable("non-replicated", SCHEMA, ClientTestUtil.getBasicCreateTableOptions().setNumReplicas(1));
        this.session.setTimeoutMillis(30000L);
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        this.session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)nonReplicatedTable, (int)1)).join();
        int numClientsBefore = this.client.getConnectionListCopy().size();
        this.harness.killAllTabletServers();
        this.harness.startAllTabletServers();
        this.session.apply((Operation)ClientTestUtil.createBasicSchemaInsert((KuduTable)nonReplicatedTable, (int)2)).join();
        int numClientsAfter = this.client.getConnectionListCopy().size();
        Assert.assertEquals((long)numClientsBefore, (long)numClientsAfter);
    }

    @Test(timeout=100000L)
    public void testKUDU232() throws Exception {
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        this.session.setFlushInterval(51000);
        this.session.apply((Operation)this.createInsert(0));
        this.session.flush().join(50000L);
        Assert.assertEquals((long)1L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
    }

    @Test(timeout=100000L)
    public void testChangingFlushModeWithOpsInFlightIsAnError() throws Exception {
        this.session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        this.session.apply((Operation)this.createInsert(10));
        try {
            this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Cannot change flush mode when writes are buffered"));
            Assert.assertEquals((Object)this.session.getFlushMode(), (Object)SessionConfiguration.FlushMode.MANUAL_FLUSH);
        }
    }

    @Test(timeout=100000L)
    public void testAutoFlushSync() throws Exception {
        int kNumOps = 1000;
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
        ArrayList<Deferred> opResponses = new ArrayList<Deferred>();
        for (int i = 0; i < 1000; ++i) {
            opResponses.add(this.session.apply((Operation)this.createInsert(i)));
        }
        Deferred.group(opResponses).join(50000L);
        Assert.assertEquals((long)1000L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
    }

    @Test(timeout=100000L)
    public void testManualFlush() throws Exception {
        int kBufferSizeOps = 10;
        this.session.setFlushMode(SessionConfiguration.FlushMode.MANUAL_FLUSH);
        this.session.setMutationBufferSpace(10);
        for (int i = 0; i < 10; ++i) {
            this.session.apply((Operation)this.createInsert(i));
        }
        Assert.assertEquals((long)0L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
        try {
            this.session.apply((Operation)this.createInsert(11));
            Assert.fail();
        }
        catch (KuduException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("MANUAL_FLUSH is enabled but the buffer is too big"));
        }
        this.session.flush().join(50000L);
        Assert.assertEquals((long)10L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
        this.session.apply((Operation)this.createInsert(11));
    }

    @Test
    public void testAutoFlushBackground() throws Exception {
        int kBufferSizeOps = 10;
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        this.session.setMutationBufferSpace(10);
        for (int i = 0; i < 20; ++i) {
            this.session.apply((Operation)this.createInsert(i));
        }
        int kNumOpsMultipler = 10;
        for (int i = 20; i < 100; ++i) {
            Insert insert = this.createInsert(i);
            try {
                this.session.apply((Operation)insert);
                continue;
            }
            catch (PleaseThrottleException ex) {
                ex.getDeferred().join(50000L);
                this.session.apply((Operation)insert);
            }
        }
        this.session.flush().join(50000L);
        Assert.assertEquals((long)100L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
    }

    @Test(timeout=100000L)
    public void testTabletCacheInvalidatedDuringWrites() throws Exception {
        Insert insert;
        int i;
        int kNumOps = 10000;
        this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        for (i = 0; i < 10000; ++i) {
            insert = this.createInsert(i);
            try {
                this.session.apply((Operation)insert);
                continue;
            }
            catch (PleaseThrottleException ex) {
                ex.getDeferred().join(50000L);
                this.session.apply((Operation)insert);
            }
        }
        this.client.emptyTabletsCacheForTable(this.table.getTableId());
        for (i = 10000; i < 20000; ++i) {
            insert = this.createInsert(i);
            try {
                this.session.apply((Operation)insert);
                continue;
            }
            catch (PleaseThrottleException ex) {
                ex.getDeferred().join(50000L);
                this.session.apply((Operation)insert);
            }
        }
        this.session.flush().join(50000L);
        Assert.assertEquals((long)20000L, (long)ClientTestUtil.countRowsInTable((KuduTable)this.table, (KuduPredicate[])new KuduPredicate[0]));
    }

    private Insert createInsert(int key) {
        return ClientTestUtil.createBasicSchemaInsert((KuduTable)this.table, (int)key);
    }

    private Tserver.TabletServerErrorPB makeTabletServerError() {
        return Tserver.TabletServerErrorPB.newBuilder().setCode(Tserver.TabletServerErrorPB.Code.UNKNOWN_ERROR).setStatus(WireProtocol.AppStatusPB.newBuilder().setCode(WireProtocol.AppStatusPB.ErrorCode.UNKNOWN_ERROR).setMessage(INJECTED_TS_ERROR).build()).build();
    }
}

