/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.test.CapturingLogAppender;
import org.apache.kudu.test.ClientTestUtil;
import org.apache.kudu.test.KuduTestHarness;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITClientStress {
    private static final Logger LOG = LoggerFactory.getLogger(ITClientStress.class);
    private static final Schema basicSchema = ClientTestUtil.getBasicSchema();
    @Rule
    public KuduTestHarness harness = new KuduTestHarness();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks(int numThreads, int secondsToRun, Supplier<Callable<Void>> taskFactory) throws InterruptedException, IOException {
        final AtomicReference<Object> thrown = new AtomicReference<Object>(null);
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(numThreads, numThreads, 100L, TimeUnit.MILLISECONDS, queue, new ThreadPoolExecutor.CallerRunsPolicy());
        CapturingLogAppender cla = new CapturingLogAppender();
        try (Closeable c = cla.attach();){
            Stopwatch s = Stopwatch.createStarted();
            while (s.elapsed(TimeUnit.SECONDS) < (long)secondsToRun && thrown.get() == null) {
                final Callable task = (Callable)taskFactory.get();
                Runnable wrapped = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.call();
                        }
                        catch (Throwable t) {
                            thrown.set(t);
                        }
                    }
                };
                pool.submit(wrapped);
            }
        }
        finally {
            pool.shutdown();
            Assert.assertTrue((boolean)pool.awaitTermination(10L, TimeUnit.SECONDS));
        }
        if (thrown.get() != null) {
            throw new AssertionError((Object)thrown.get());
        }
        Assert.assertFalse((String)"log contained NPE", (boolean)cla.getAppendedText().contains("NullPointerException"));
        Assert.assertFalse((String)"log contained SSLException", (boolean)cla.getAppendedText().contains("SSLException"));
        Assert.assertFalse((String)"log contained IllegalStateException", (boolean)cla.getAppendedText().contains("IllegalStateException"));
    }

    @Test(timeout=300000L)
    public void testManyShortClientsGeneratingScanTokens() throws Exception {
        String TABLE_NAME = "testManyClients";
        int SECONDS_TO_RUN = 10;
        int NUM_THREADS = 80;
        ClientTestUtil.createFourTabletsTableWithNineRows((AsyncKuduClient)this.harness.getAsyncClient(), (String)"testManyClients", (long)50000L);
        this.runTasks(80, 10, new Supplier<Callable<Void>>(){

            public Callable<Void> get() {
                return new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try (AsyncKuduClient client = new AsyncKuduClient.AsyncKuduClientBuilder(ITClientStress.this.harness.getMasterAddressesAsString()).defaultAdminOperationTimeoutMs(50000L).build();){
                            KuduTable t = (KuduTable)client.openTable("testManyClients").join();
                            new KuduScanToken.KuduScanTokenBuilder(client, t).build();
                        }
                        return null;
                    }
                };
            }
        });
    }

    @Test(timeout=300000L)
    public void testMultipleSessions() throws Exception {
        String TABLE_NAME = "testMultipleSessions";
        int SECONDS_TO_RUN = 10;
        int NUM_THREADS = 60;
        final KuduTable table = this.harness.getClient().createTable("testMultipleSessions", basicSchema, ClientTestUtil.getBasicCreateTableOptions());
        final AtomicInteger numUpserted = new AtomicInteger(0);
        this.runTasks(60, 10, new Supplier<Callable<Void>>(){

            public Callable<Void> get() {
                return new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        s.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC);
                        try (KuduSession s = ITClientStress.this.harness.getClient().newSession();){
                            for (int i = 0; i < 100; ++i) {
                                Upsert u = table.newUpsert();
                                u.getRow().addInt(0, i);
                                u.getRow().addInt(1, 12345);
                                u.getRow().addInt(2, 3);
                                u.getRow().setNull(3);
                                u.getRow().addBoolean(4, false);
                                OperationResponse apply = s.apply((Operation)u);
                                if (apply.hasRowError()) {
                                    throw new AssertionError((Object)apply.getRowError().toString());
                                }
                                numUpserted.incrementAndGet();
                            }
                        }
                        return null;
                    }
                };
            }
        });
        LOG.info("Upserted {} rows", (Object)numUpserted.get());
    }
}

