/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Type;
import org.apache.kudu.test.junit.RetryRule;
import org.apache.kudu.util.CharUtil;
import org.apache.kudu.util.DecimalUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class TestColumnSchema {
    @Rule
    public RetryRule retryRule = new RetryRule();

    @Test
    public void testToString() {
        ColumnSchema col1 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.STRING).build();
        ColumnSchema col2 = new ColumnSchema.ColumnSchemaBuilder("col2", Type.INT64).build();
        ColumnSchema col3 = new ColumnSchema.ColumnSchemaBuilder("col3", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)5, (int)2)).build();
        ColumnSchema col4 = new ColumnSchema.ColumnSchemaBuilder("col4", Type.INT16).comment("test comment").build();
        Assert.assertEquals((Object)"Column name: col1, type: string", (Object)col1.toString());
        Assert.assertEquals((Object)"Column name: col2, type: int64", (Object)col2.toString());
        Assert.assertEquals((Object)"Column name: col3, type: decimal(5, 2)", (Object)col3.toString());
        Assert.assertEquals((Object)"Column name: col4, type: int16, comment: test comment", (Object)col4.toString());
    }

    @Test
    public void testEquals() {
        ColumnSchema stringCol1 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.STRING).defaultValue((Object)"test").build();
        Assert.assertEquals((Object)stringCol1, (Object)stringCol1);
        ColumnSchema stringCol2 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.STRING).defaultValue((Object)"test").build();
        Assert.assertEquals((Object)stringCol1, (Object)stringCol2);
        ColumnSchema isKey = new ColumnSchema.ColumnSchemaBuilder("col1", Type.STRING).key(true).build();
        Assert.assertNotEquals((Object)stringCol1, (Object)isKey);
        ColumnSchema isInt = new ColumnSchema.ColumnSchemaBuilder("col1", Type.INT32).build();
        Assert.assertNotEquals((Object)stringCol1, (Object)isInt);
        ColumnSchema decCol1 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)2)).build();
        ColumnSchema decCol2 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)2)).build();
        Assert.assertEquals((Object)decCol1, (Object)decCol2);
        ColumnSchema decCol3 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes((int)9, (int)0)).build();
        Assert.assertNotEquals((Object)decCol1, (Object)decCol3);
        ColumnSchema commentInt1 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.INT32).comment("test").build();
        ColumnSchema commentInt2 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.INT32).comment("test").build();
        Assert.assertEquals((Object)commentInt1, (Object)commentInt2);
        ColumnSchema commentInt3 = new ColumnSchema.ColumnSchemaBuilder("col1", Type.INT32).comment("Test").build();
        Assert.assertNotEquals((Object)commentInt1, (Object)commentInt3);
    }

    @Test
    public void testOutOfRangeVarchar() throws Exception {
        Throwable thrown = Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Exception {
                new ColumnSchema.ColumnSchemaBuilder("col1", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes((int)70000)).build();
            }
        });
        Assert.assertTrue((boolean)thrown.getMessage().contains("VARCHAR's length must be set and between 1 and 65535"));
    }

    @Test
    public void testVarcharWithoutLength() throws Exception {
        Throwable thrown = Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Exception {
                new ColumnSchema.ColumnSchemaBuilder("col1", Type.VARCHAR).build();
            }
        });
        Assert.assertTrue((boolean)thrown.getMessage().contains("VARCHAR's length must be set and between 1 and 65535"));
    }
}

