/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;

public class KuduMetastorePlugin
extends MetaStoreEventListener {
    @VisibleForTesting
    static final String KUDU_STORAGE_HANDLER = "org.apache.hadoop.hive.kudu.KuduStorageHandler";
    @VisibleForTesting
    static final String LEGACY_KUDU_STORAGE_HANDLER = "com.cloudera.kudu.hive.KuduStorageHandler";
    @VisibleForTesting
    static final String KUDU_TABLE_ID_KEY = "kudu.table_id";
    @VisibleForTesting
    static final String KUDU_TABLE_NAME = "kudu.table_name";
    @VisibleForTesting
    static final String KUDU_MASTER_ADDRS_KEY = "kudu.master_addresses";
    @VisibleForTesting
    static final String KUDU_MASTER_EVENT = "kudu.master_event";
    @VisibleForTesting
    static final String KUDU_CHECK_ID_KEY = "kudu.check_id";
    @VisibleForTesting
    static final String EXTERNAL_TABLE_KEY = "EXTERNAL";
    static final String EXTERNAL_PURGE_KEY = "external.table.purge";
    static final String SKIP_VALIDATION_ENV = "KUDU_SKIP_HMS_PLUGIN_VALIDATION";

    public KuduMetastorePlugin(Configuration config) {
        super(config);
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        super.onCreateTable(tableEvent);
        if (KuduMetastorePlugin.skipsValidation()) {
            return;
        }
        Table table = tableEvent.getTable();
        if (!this.isSynchronizedTable(table)) {
            return;
        }
        if (!this.isKuduTable(table)) {
            this.checkNoKuduProperties(table);
            return;
        }
        if (!this.isKuduMasterAction((ListenerEvent)tableEvent)) {
            throw new MetaException("Kudu tables may not be created through Hive");
        }
        this.checkKuduProperties(table);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        String targetTableId;
        super.onDropTable(tableEvent);
        Table table = tableEvent.getTable();
        if (KuduMetastorePlugin.skipsValidation()) {
            return;
        }
        if (!this.isSynchronizedTable(table)) {
            return;
        }
        EnvironmentContext environmentContext = tableEvent.getEnvironmentContext();
        String string = targetTableId = environmentContext == null ? null : (String)environmentContext.getProperties().get(KUDU_TABLE_ID_KEY);
        if (targetTableId == null) {
            return;
        }
        if (!this.isKuduTable(table)) {
            throw new MetaException("Kudu table ID does not match the non-Kudu HMS entry");
        }
        if (!targetTableId.equals(table.getParameters().get(KUDU_TABLE_ID_KEY))) {
            throw new MetaException("Kudu table ID does not match the HMS entry");
        }
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        super.onAlterTable(tableEvent);
        if (KuduMetastorePlugin.skipsValidation()) {
            return;
        }
        Table oldTable = tableEvent.getOldTable();
        Table newTable = tableEvent.getNewTable();
        if (!(!this.isKuduTable(oldTable) || this.isKuduMasterAction((ListenerEvent)tableEvent) || Objects.equals(oldTable.getTableType(), newTable.getTableType()) && this.isExternalTable(oldTable) == this.isExternalTable(newTable) && this.isPurgeTable(oldTable) == this.isPurgeTable(newTable))) {
            throw new MetaException("Kudu table type may not be altered");
        }
        if (!this.isSynchronizedTable(oldTable)) {
            return;
        }
        if (this.isLegacyKuduTable(oldTable)) {
            if (this.isKuduTable(newTable)) {
                this.checkKuduProperties(newTable);
                this.checkOnlyKuduMasterCanAlterSchema(tableEvent, oldTable, newTable);
                return;
            }
            this.checkNoKuduProperties(newTable);
        } else if (this.isKuduTable(oldTable)) {
            if (this.isLegacyKuduTable(newTable)) {
                this.checkNoKuduProperties(newTable);
                this.checkOnlyKuduMasterCanAlterSchema(tableEvent, oldTable, newTable);
                return;
            }
            this.checkKuduProperties(newTable);
            this.checkOnlyKuduMasterCanAlterSchema(tableEvent, oldTable, newTable);
            if (this.checkTableID((ListenerEvent)tableEvent)) {
                String oldTableId = (String)oldTable.getParameters().get(KUDU_TABLE_ID_KEY);
                String newTableId = (String)newTable.getParameters().get(KUDU_TABLE_ID_KEY);
                if (!newTableId.equals(oldTableId)) {
                    throw new MetaException("Kudu table ID does not match the existing HMS entry");
                }
            }
        } else {
            this.checkNoKuduProperties(newTable);
        }
    }

    private boolean isKuduTable(Table table) {
        String storageHandler = (String)table.getParameters().get("storage_handler");
        return KUDU_STORAGE_HANDLER.equals(storageHandler);
    }

    private boolean isLegacyKuduTable(Table table) {
        return LEGACY_KUDU_STORAGE_HANDLER.equals(table.getParameters().get("storage_handler"));
    }

    private boolean isExternalTable(Table table) {
        String isExternal = (String)table.getParameters().get(EXTERNAL_TABLE_KEY);
        if (isExternal == null) {
            return false;
        }
        return Boolean.parseBoolean(isExternal);
    }

    private boolean isPurgeTable(Table table) {
        boolean externalPurge = Boolean.parseBoolean(table.getParameters().getOrDefault(EXTERNAL_PURGE_KEY, "false"));
        return TableType.MANAGED_TABLE.name().equals(table.getTableType()) || externalPurge;
    }

    private boolean isSynchronizedTable(Table table) {
        return TableType.MANAGED_TABLE.name().equals(table.getTableType()) || this.isExternalTable(table) && this.isPurgeTable(table);
    }

    private void checkKuduProperties(Table table) throws MetaException {
        if (!this.isKuduTable(table)) {
            throw new MetaException(String.format("Kudu table entry must contain a Kudu storage handler property (%s=%s)", "storage_handler", KUDU_STORAGE_HANDLER));
        }
        String tableId = (String)table.getParameters().get(KUDU_TABLE_ID_KEY);
        if (tableId == null || tableId.isEmpty()) {
            throw new MetaException(String.format("Kudu table entry must contain a table ID property (%s)", KUDU_TABLE_ID_KEY));
        }
        String masterAddresses = (String)table.getParameters().get(KUDU_MASTER_ADDRS_KEY);
        if (masterAddresses == null || masterAddresses.isEmpty()) {
            throw new MetaException(String.format("Kudu table entry must contain a Master addresses property (%s)", KUDU_MASTER_ADDRS_KEY));
        }
    }

    private void checkNoKuduProperties(Table table) throws MetaException {
        if (this.isKuduTable(table)) {
            throw new MetaException(String.format("non-Kudu table entry must not contain the Kudu storage handler (%s=%s)", "storage_handler", KUDU_STORAGE_HANDLER));
        }
        if (table.getParameters().containsKey(KUDU_TABLE_ID_KEY)) {
            throw new MetaException(String.format("non-Kudu table entry must not contain a table ID property (%s)", KUDU_TABLE_ID_KEY));
        }
    }

    private void checkOnlyKuduMasterCanAlterSchema(AlterTableEvent tableEvent, Table oldTable, Table newTable) throws MetaException {
        if (!this.isKuduMasterAction((ListenerEvent)tableEvent) && !oldTable.getSd().getCols().equals(newTable.getSd().getCols())) {
            throw new MetaException("Kudu table columns may not be altered through Hive");
        }
    }

    private boolean isKuduMasterAction(ListenerEvent event) {
        EnvironmentContext environmentContext = event.getEnvironmentContext();
        if (environmentContext == null) {
            return false;
        }
        Map properties = environmentContext.getProperties();
        if (properties == null) {
            return false;
        }
        if (!properties.containsKey(KUDU_MASTER_EVENT)) {
            return false;
        }
        return Boolean.parseBoolean((String)properties.get(KUDU_MASTER_EVENT));
    }

    private boolean checkTableID(ListenerEvent event) {
        EnvironmentContext environmentContext = event.getEnvironmentContext();
        if (environmentContext == null) {
            return true;
        }
        Map properties = environmentContext.getProperties();
        if (properties == null) {
            return true;
        }
        if (!properties.containsKey(KUDU_CHECK_ID_KEY)) {
            return true;
        }
        return Boolean.parseBoolean((String)properties.get(KUDU_CHECK_ID_KEY));
    }

    private static boolean skipsValidation() {
        String skipValidation = System.getenv(SKIP_VALIDATION_ENV);
        return skipValidation != null && !skipValidation.isEmpty() && Integer.parseInt(skipValidation) != 0;
    }
}

